package com.bxm.thirdparty.platform.service.impl;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.bxm.newidea.component.notify.NotifyMessageSender;
import com.bxm.newidea.component.notify.channel.ChannelBuilder;
import com.bxm.newidea.component.notify.message.NotifyMessageBuilder;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.mapper.ThirdPartyFailLogMapper;
import com.bxm.thirdparty.platform.model.entity.ThirdPartyFailLogEntity;
import com.bxm.thirdparty.platform.queue.notifybusiness.enums.NotifyStatusEnum;
import com.bxm.thirdparty.platform.service.ThirdPartyFailService;
import com.bxm.thirdparty.platform.service.impl.bo.ThirdPartyFailBO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/4/18 10:14
 */
@Slf4j
@Service
@AllArgsConstructor
public class ThirdPartyFailServiceImpl implements ThirdPartyFailService {

    private final ThirdPartyFailLogMapper thirdPartyFailLogMapper;

    private final ThirdPartyConfigProperties thirdPartyConfigProperties;

    private final NotifyMessageSender notifyMessageSender;

    @Override
    public void submitThirdPartyFailLog(ThirdPartyFailBO thirdPartyFailBO) {
        ThirdPartyFailLogEntity thirdPartyFailLogEntity = thirdPartyFailLogMapper.getByRequestId(thirdPartyFailBO.getRequestId());

        if (Objects.isNull(thirdPartyFailLogEntity)) {
            int nextInterval = thirdPartyConfigProperties.getRetryIntervalArray()[0];
            DateTime offset = DateUtil.offset(new Date(), DateField.SECOND, nextInterval);
            thirdPartyFailLogEntity = new ThirdPartyFailLogEntity();
            thirdPartyFailLogEntity.setId(SequenceHolder.nextLongId());
            thirdPartyFailLogEntity.setParamDto(thirdPartyFailBO.getParam());
            thirdPartyFailLogEntity.setRequestId(thirdPartyFailBO.getRequestId());
            thirdPartyFailLogEntity.setFailNum(1);
            thirdPartyFailLogEntity.setPlatform(thirdPartyFailBO.getTypeEnum().name());
            thirdPartyFailLogEntity.setCreateTime(new Date());
            thirdPartyFailLogEntity.setNextRetryTime(offset.toJdkDate());
            thirdPartyFailLogEntity.setStatus(NotifyStatusEnum.WAIT_ING.getStatus());
            thirdPartyFailLogEntity.setErrorMsg(thirdPartyFailBO.getErrorMsg());
            thirdPartyFailLogMapper.insert(thirdPartyFailLogEntity);
        } else {
            if (thirdPartyFailLogEntity.getFailNum() + 1 >= thirdPartyConfigProperties.getRetryIntervalArray().length) {
                log.error(
                        "第三方服务[{}]重试次数达到[{}]次，requestId:{},直接记录为失败,最近一次失败信息为：{}",
                        thirdPartyFailLogEntity.getPlatform(),
                        thirdPartyFailLogEntity.getFailNum(),
                        thirdPartyFailLogEntity.getRequestId(),
                        thirdPartyFailBO.getErrorMsg()
                );
                notifyMessageSender.send(NotifyMessageBuilder.textMessage().title("第三方服务失败通知")
                        .content("第三方服务失败通知：重试类型为" + thirdPartyFailLogEntity.getPlatform() + "\n" +
                                "最后一次失败返回信息：" + thirdPartyFailBO.getErrorMsg() + "\n" +
                                "requestId:" + thirdPartyFailLogEntity.getRequestId() + "")
                        .bindChannel(ChannelBuilder.dingding(thirdPartyConfigProperties.getDingdingUrl()))
                        .build());
                return;
            }
            Integer failNum = thirdPartyFailLogEntity.getFailNum() + 1;
            int nextInterval = thirdPartyConfigProperties.getRetryIntervalArray()[thirdPartyFailLogEntity.getFailNum()];
            DateTime offset = DateUtil.offset(new Date(), DateField.SECOND, nextInterval);

            ThirdPartyFailLogEntity updateClass = new ThirdPartyFailLogEntity();
            updateClass.setId(thirdPartyFailLogEntity.getId());
            updateClass.setNextRetryTime(offset.toJdkDate());
            //失败了，更新状态成的待处理
            updateClass.setStatus(NotifyStatusEnum.WAIT_ING.getStatus());
            updateClass.setFailNum(failNum);
            updateClass.setErrorMsg(thirdPartyFailBO.getErrorMsg());
            thirdPartyFailLogMapper.updateById(updateClass);
        }
    }

    @Override
    public void updateThirdPartySuccess(String requestId) {
        ThirdPartyFailLogEntity thirdPartyFailLogEntity = thirdPartyFailLogMapper.getByRequestId(requestId);
        if (Objects.isNull(thirdPartyFailLogEntity)) {
            log.error(
                    "requestId：{}第三方重试成功，但未查询到通知信息",
                    requestId
            );
            return;
        }
        ThirdPartyFailLogEntity updateClass = new ThirdPartyFailLogEntity();
        updateClass.setId(thirdPartyFailLogEntity.getId());
        updateClass.setStatus(NotifyStatusEnum.SUCCESS.getStatus());
        thirdPartyFailLogMapper.updateById(updateClass);
    }

    @Override
    public void platformRetry() {

    }
}
