package com.bxm.thirdparty.platform.thirdpartyretry;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.cache.QueueRedisKey;
import com.bxm.thirdparty.platform.model.entity.ThirdPartyFailLogEntity;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * 业务通知缓存管理
 *
 * @author lowi
 */
@Component
@AllArgsConstructor
public class ThirdPartyFailCacheHolder {

    private final RedisListAdapter redisListAdapter;

    public void addToQueue(ThirdPartyFailLogEntity thirdPartyFailLogEntity) {
        redisListAdapter.leftPush(QueueRedisKey.THIRD_PARTY_FAIL.copy(), thirdPartyFailLogEntity);
    }

    public ThirdPartyFailLogEntity pop() {
        return redisListAdapter.rightPop(QueueRedisKey.THIRD_PARTY_FAIL.copy(), ThirdPartyFailLogEntity.class);
    }
}
