package com.bxm.thirdparty.platform.timer;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.schedule.AbstractCronXxlJob;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.facade.enums.NotifyTypeEnum;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import com.bxm.thirdparty.platform.mapper.ThirdPartyFailLogMapper;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import com.bxm.thirdparty.platform.model.entity.ThirdPartyFailLogEntity;
import com.bxm.thirdparty.platform.service.ThirdPartyFailService;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.checkerframework.checker.units.qual.C;
import org.springframework.stereotype.Component;
import com.bxm.thirdparty.platform.thirdpartyretry.ThirdPartyFailCacheHolder;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author lowi
 * @date 2023/3/10 13:21
 */
@Component
@Slf4j
public class AddThirdPartyFailTask extends AbstractCronXxlJob {

    @Resource
    private ThirdPartyFailLogMapper thirdPartyFailLogMapper;

    @Resource
    private ThirdPartyFailService thirdPartyFailService;

    @Resource
    private ThirdPartyFailCacheHolder thirdPartyFailCacheHolder;

    private static final Integer LIMIT = 100;

    @Override
    public void executeLogic() {
        loopFetch(0L);
    }


    private void loopFetch(Long lastRecordId) {
        List<ThirdPartyFailLogEntity> readyList = thirdPartyFailLogMapper.queryReadyItemList(lastRecordId, LIMIT);

        for (ThirdPartyFailLogEntity entity : readyList) {
            ThirdPartyFailLogEntity updateClass = new ThirdPartyFailLogEntity();
            updateClass.setId(entity.getId());
            updateClass.setStatus(1);
            thirdPartyFailLogMapper.updateById(updateClass);
            //放入队列
            thirdPartyFailCacheHolder.addToQueue(entity);
        }

        if (readyList.size() >= LIMIT) {
            loopFetch(readyList.get(readyList.size() - 1).getId());
        }
    }

    @Override
    protected String cron() {
        return "0/5 * * * * ?";
    }

    @Override
    public String jobDesc() {
        return "执行业务通知";
    }

    @Override
    public String author() {
        return "lowi";
    }
}
