package com.bxm.thirdparty.platform.timer;

import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.schedule.AbstractCronXxlJob;
import com.bxm.thirdparty.platform.model.entity.ThirdPartyFailLogEntity;
import com.bxm.thirdparty.platform.service.ThirdPartyFailService;
import com.bxm.thirdparty.platform.thirdpartyretry.ThirdPartyFailCacheHolder;
import com.bxm.thirdparty.platform.thirdpartyretry.strategy.ThirdPartyRetryManage;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * @author lowi
 * @date 2023/3/10 13:21
 */
@Component
@Slf4j
public class ThirdPartyRetryTask extends AbstractCronXxlJob {

    @Resource
    private ThirdPartyFailCacheHolder thirdPartyFailCacheHolder;

    @Resource
    private ThirdPartyRetryManage thirdPartyRetryManage;

    @Resource
    private ThirdPartyFailService thirdPartyFailService;

    @Override
    public void executeLogic() {
        loopFetch();
    }

    private void loopFetch() {
        ThirdPartyFailLogEntity pop = thirdPartyFailCacheHolder.pop();
        if (pop != null) {
            Message message = thirdPartyRetryManage.execRetry(pop);
            if (message.isSuccess()) {
                thirdPartyFailService.updateThirdPartySuccess(pop.getRequestId());
            }
            loopFetch();
        }

    }

    @Override
    protected String cron() {
        return "0/5 * * * * ?";
    }

    @Override
    public String jobDesc() {
        return "执行业务通知";
    }

    @Override
    public String author() {
        return "lowi";
    }
}
