/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.interceptor.IThirdPartyInterceptor;
import com.bxm.thirdparty.platform.queue.QueueService;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.bo.RequestBodyBO;
import com.bxm.thirdparty.platform.utils.TraceUtil;
import java.util.List;
import javax.annotation.Resource;

public abstract class AbstractThirdPartyPlatformAction<T extends BaseRequest, O> {
    @Resource
    private QueueService queueService;

    protected abstract Message exec(PlatformContext<T, O> var1);

    protected abstract Class<? extends BaseRequest> support();

    protected Message fallback(T t) {
        return Message.build((boolean)false).setMessage("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    protected int retryNum() {
        return 0;
    }

    protected Integer timeout() {
        return 5000;
    }

    protected List<Class<? extends IThirdPartyInterceptor>> interceptors() {
        return null;
    }

    Message execPlatform(PlatformContext<T, O> context) {
        TraceUtil.asynReplaceRequestId(context.getRequestId());
        return this.exec(context);
    }

    protected abstract Message mockResult(PlatformContext<T, O> var1);

    protected Message asyncResult(PlatformContext<T, O> context) {
        return Message.build();
    }

    protected void submitQueueNotify(PlatformContext<T, O> context, String jsonStr) {
        QueueBO queueBO = new QueueBO();
        queueBO.setNotifyUrl(context.getNotifyUrl());
        queueBO.setApplicationName(((BaseRequest)context.getRequest()).getApplicationName());
        queueBO.setDelayTime(5);
        queueBO.setRequestId(ThreadContext.getRequestId());
        queueBO.setRequestBodyBO(RequestBodyBO.builder().requestId(ThreadContext.getRequestId()).type(context.getNotifyType().name()).result(jsonStr).build());
        this.queueService.submitBusinessNotify(queueBO);
    }
}

