/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.chargephone;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.AbstractThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.adapter.chargephone.IChargePhoneActionDispatcher;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.facade.notify.ChargePhoneNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import com.bxm.thirdparty.platform.facade.response.ChargePhoneTopUpResponse;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import com.bxm.thirdparty.platform.service.ThirdPartyFailService;
import com.bxm.thirdparty.platform.service.impl.bo.ThirdPartyFailBO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ChargePhonePlatformAction
extends AbstractThirdPartyPlatformAction<ChargePhoneRequest, ChargesPhoneLogEntity> {
    private static final Logger log = LoggerFactory.getLogger(ChargePhonePlatformAction.class);
    @Resource
    private IChargePhoneActionDispatcher<ChargePhoneRequest, ChargesPhoneLogEntity> iChargePhoneActionDispatcher;
    @Resource
    private ThirdPartyFailService thirdPartyFailService;

    @Override
    protected Message exec(PlatformContext context) {
        Message exec = this.iChargePhoneActionDispatcher.exec(context);
        log.info("\u5145\u8bdd\u8d39\u52a8\u4f5c\u7ed3\u675f:{}", (Object)JSON.toJSONString((Object)exec.getParam(CommonConstant.RESULT_DTO)));
        if (!exec.isSuccess()) {
            this.thirdPartyFailService.submitThirdPartyFailLog(ThirdPartyFailBO.builder().param(JSON.toJSONString((Object)context)).typeEnum(PlatformBusinessTypeEnum.CHARGE_PHONE).errorMsg(exec.getLastMessage()).requestId(context.getRequestId()).build());
        }
        return exec;
    }

    @Override
    protected Message mockResult(PlatformContext<ChargePhoneRequest, ChargesPhoneLogEntity> context) {
        ChargePhoneRequest request = context.getRequest();
        ChargesPhoneLogEntity orderNo = context.getOrderInfo();
        ChargePhoneTopUpResponse response = new ChargePhoneTopUpResponse();
        response.setRequestId(context.getRequestId());
        response.setMoney(request.getMoney());
        response.setPhoneNo(request.getPhoneNo());
        response.setOutOrderNo(orderNo.getOutOrderNo());
        response.setOrderNo(orderNo.getOrderNo());
        ChargePhoneNotifyResponse notifyResponse = new ChargePhoneNotifyResponse();
        notifyResponse.setRequestId(context.getRequestId());
        notifyResponse.setSuccess(Boolean.valueOf(true));
        notifyResponse.setOrderNo(orderNo.getOrderNo());
        notifyResponse.setOutOrderNo(orderNo.getOutOrderNo());
        this.submitQueueNotify(context, JSON.toJSONString((Object)notifyResponse));
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }

    @Override
    public Class<? extends BaseRequest> support() {
        return ChargePhoneRequest.class;
    }

    @Override
    protected Message asyncResult(PlatformContext<ChargePhoneRequest, ChargesPhoneLogEntity> context) {
        ChargePhoneRequest request = context.getRequest();
        ChargesPhoneLogEntity orderNo = context.getOrderInfo();
        ChargePhoneTopUpResponse response = new ChargePhoneTopUpResponse();
        response.setRequestId(context.getRequestId());
        response.setMoney(request.getMoney());
        response.setPhoneNo(request.getPhoneNo());
        response.setOutOrderNo(orderNo.getOutOrderNo());
        response.setOrderNo(orderNo.getOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }
}

