/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.chargephone.gongmao;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.notify.NotifyMessageSender;
import com.bxm.newidea.component.notify.channel.ChannelBuilder;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.message.NotifyMessageBuilder;
import com.bxm.newidea.component.notify.message.TextNotifyMessage;
import com.bxm.thirdparty.platform.adapter.chargephone.ChargePhoneAction;
import com.bxm.thirdparty.platform.adapter.chargephone.gongmao.bo.GongMaoBalanceBO;
import com.bxm.thirdparty.platform.adapter.chargephone.gongmao.bo.GongMaoOrderResultBO;
import com.bxm.thirdparty.platform.adapter.chargephone.gongmao.bo.GongMaoResultBO;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import com.bxm.thirdparty.platform.facade.response.ChargePhoneTopUpResponse;
import com.bxm.thirdparty.platform.mapper.ChargesPhoneLogMapper;
import com.bxm.thirdparty.platform.mapper.PhoneAnalysisMapper;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import com.bxm.thirdparty.platform.model.entity.PhoneAnalysisEntity;
import com.bxm.thirdparty.platform.utils.GongMaoUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GongMaoChargePhoneAction
implements ChargePhoneAction<ChargePhoneRequest, ChargesPhoneLogEntity> {
    private static final Logger log = LoggerFactory.getLogger(GongMaoChargePhoneAction.class);
    @Resource
    private NotifyMessageSender notifyMessageSender;
    @Resource
    private ChargesPhoneLogMapper chargesPhoneLogMapper;
    @Resource
    private ThirdPartyConfigProperties thirdPartyConfigProperties;
    @Resource
    private PhoneAnalysisMapper phoneAnalysisMapper;

    @Override
    public PlatformEnum support() {
        return PlatformEnum.GONG_MAO_CHARGE_PHONE;
    }

    @Override
    public Message exec(PlatformContext<ChargePhoneRequest, ChargesPhoneLogEntity> context) {
        ChargePhoneRequest request = context.getRequest();
        ChargesPhoneLogEntity orderInfo = context.getOrderInfo();
        BigDecimal money = request.getMoney();
        String phoneNo = request.getPhoneNo();
        String carrier = this.getPhoneCarrier(phoneNo);
        Optional<ThirdPartyConfigProperties.GongMaoChargePhoneDict> chargePhoneDictOptional = this.thirdPartyConfigProperties.getGongMaoChargePhoneDictList().stream().filter(gongMaoChargePhoneDict -> Objects.equals(gongMaoChargePhoneDict.getPhoneCarrier(), carrier) && gongMaoChargePhoneDict.getFaceValue().compareTo(money) == 0).findFirst();
        if (!chargePhoneDictOptional.isPresent()) {
            log.error("\u5de5\u732b\u8bdd\u8d39\u5145\u503c\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u5de5\u732b\u4ea7\u54c1\u5b57\u5178\uff1a{}\uff0ccarrier\uff1a{}", context, (Object)carrier);
            return Message.build((boolean)false).setMessage("\u5de5\u732b\u8bdd\u8d39\u5145\u503c\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u5de5\u732b\u4ea7\u54c1\u5b57\u5178");
        }
        ThirdPartyConfigProperties.GongMaoChargePhoneDict gongMaoChargePhoneDict2 = chargePhoneDictOptional.get();
        GongMaoUtil gongMaoUtil = new GongMaoUtil(this.thirdPartyConfigProperties);
        GongMaoBalanceBO balance = gongMaoUtil.getBalance();
        if (balance == null) {
            log.error("\u5de5\u732b\u8bdd\u8d39\u5145\u503c\u5931\u8d25\uff0c\u83b7\u53d6\u8d26\u6237\u4f59\u989d\u5931\u8d25\uff1a{}", context);
            return Message.build((boolean)false).setMessage("\u83b7\u53d6\u5de5\u732b\u8d26\u6237\u4f59\u989d\u5931\u8d25");
        }
        this.remindAccountMoney(balance);
        if (balance.getAvailableAmount().compareTo(money) < 0) {
            log.error("\u5de5\u732b\u8bdd\u8d39\u5145\u503c\u5931\u8d25\uff0c\u5145\u503c\u4f59\u989d\u4e0d\u8db3\uff1a{}", (Object)request);
            return Message.build((boolean)false).setMessage("\u5145\u503c\u4f59\u989d\u4e0d\u8db3");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("requestId", orderInfo.getOrderNo());
        paramMap.put("productId", gongMaoChargePhoneDict2.getProductId());
        paramMap.put("faceValue", gongMaoChargePhoneDict2.getFaceValue());
        paramMap.put("account", phoneNo);
        paramMap.put("orderCallbackUrl", this.thirdPartyConfigProperties.getServerUrl() + this.thirdPartyConfigProperties.getGongMaoChargePhoneCallbackUrl());
        String body = gongMaoUtil.submitOrder(paramMap);
        if (Objects.isNull(body)) {
            return Message.build((boolean)false).setBizCode("THIRD_PARTY_500").setMessage("\u8c03\u7528\u7b2c\u4e09\u65b9\u8bdd\u8d39\u5145\u503c\u5931\u8d25");
        }
        GongMaoResultBO gongMaoResultBO = (GongMaoResultBO)JSON.parseObject((String)body, GongMaoResultBO.class);
        if (Objects.isNull(gongMaoResultBO) || Objects.nonNull(gongMaoResultBO.getCode()) || !gongMaoResultBO.getSuccess().booleanValue()) {
            return Message.build((boolean)false).setBizCode("THIRD_PARTY_500").setMessage(body);
        }
        GongMaoOrderResultBO resultBO = (GongMaoOrderResultBO)JSON.parseObject((String)JSON.toJSONString((Object)gongMaoResultBO.getData()), GongMaoOrderResultBO.class);
        this.updateChargePhoneLog(orderInfo.getId(), resultBO.getOrderNo());
        ChargePhoneTopUpResponse response = new ChargePhoneTopUpResponse();
        response.setRequestId(ThreadContext.getRequestId());
        response.setResult(body);
        response.setPhoneNo(phoneNo);
        response.setMoney(gongMaoChargePhoneDict2.getFaceValue());
        response.setOrderNo(orderInfo.getOrderNo());
        response.setOutOrderNo(request.getOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }

    private void updateChargePhoneLog(Long id, String outOrderNo) {
        ChargesPhoneLogEntity chargesPhoneLogEntity = new ChargesPhoneLogEntity();
        chargesPhoneLogEntity.setId(id);
        chargesPhoneLogEntity.setThirdPartyTrackNo(outOrderNo);
        this.chargesPhoneLogMapper.updateById((Object)chargesPhoneLogEntity);
    }

    private void remindAccountMoney(GongMaoBalanceBO balance) {
        if (Objects.nonNull(balance) && balance.getAvailableAmount().compareTo(this.thirdPartyConfigProperties.getAccountBalanceRemind()) <= 0) {
            this.notifyMessageSender.send((NotifyMessage)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)NotifyMessageBuilder.textMessage().title("\u5de5\u732b\u5e73\u53f0\u4f59\u989d\u9884\u8b66")).content("\u5de5\u732b\u5e73\u53f0\u4f59\u989d\u9884\u8b66\uff1a\n\u5f53\u524d\u53ef\u7528\u91d1\u989d" + (balance.getAvailableAmount() == null ? BigDecimal.ZERO : balance.getAvailableAmount()) + "\n\u5f53\u524d\u603b\u91d1\u989d" + (balance.getTotalAmount() == null ? BigDecimal.ZERO : balance.getAvailableAmount()) + "\n\u5f53\u524d\u51bb\u7ed3\u91d1\u989d" + (balance.getFrozenAmount() == null ? BigDecimal.ZERO : balance.getAvailableAmount()) + "\n\u8bf7\u53ca\u65f6\u5145\u503c\uff01\uff01\uff01\uff01\uff01\nrequestId:" + ThreadContext.getRequestId() + "")).bindChannel(ChannelBuilder.dingding((String)this.thirdPartyConfigProperties.getDingdingUrl()))).build());
        }
    }

    private String getPhoneCarrier(String phone) {
        PhoneAnalysisEntity phoneIspInfo = this.phoneAnalysisMapper.getPhoneIspInfo(phone);
        if (phoneIspInfo != null) {
            return phoneIspInfo.getIsp();
        }
        return "";
    }
}

