/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.electric.liba;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.notify.NotifyMessageSender;
import com.bxm.newidea.component.notify.channel.ChannelBuilder;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.message.NotifyMessageBuilder;
import com.bxm.newidea.component.notify.message.TextNotifyMessage;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.adapter.electric.ElectricAction;
import com.bxm.thirdparty.platform.adapter.electric.liba.bo.LiBaBO;
import com.bxm.thirdparty.platform.adapter.electric.liba.bo.LiBaCreateOrderResultBO;
import com.bxm.thirdparty.platform.adapter.electric.liba.utils.LiBaUtil;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.ElectricRequest;
import com.bxm.thirdparty.platform.facade.response.ElectricTopUpResponse;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LiBaElectricAction
implements ElectricAction<ElectricRequest, ElectricLogEntity> {
    private static final Logger log = LoggerFactory.getLogger(LiBaElectricAction.class);
    @Resource
    private ThirdPartyConfigProperties thirdPartyConfigProperties;
    @Resource
    private NotifyMessageSender notifyMessageSender;

    @Override
    public PlatformEnum support() {
        return PlatformEnum.LI_BA;
    }

    @Override
    public Message exec(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        ElectricRequest liBaRequest = context.getRequest();
        ElectricLogEntity orderInfo = context.getOrderInfo();
        LiBaUtil libaUtil = new LiBaUtil(this.thirdPartyConfigProperties);
        BigDecimal balance = libaUtil.checkAccount();
        this.remindAccountMoney(balance);
        if (balance.compareTo(liBaRequest.getAmount()) < 0) {
            log.error("liba\u8bdd\u8d39\u5145\u503c\u5931\u8d25\uff0c\u5145\u503c\u4f59\u989d\u4e0d\u8db3\uff1a{}", context);
            return Message.build((boolean)false).setMessage("\u5145\u503c\u4f59\u989d\u4e0d\u8db3");
        }
        String province = liBaRequest.getProvince().replaceAll("\u7701", "");
        String city = liBaRequest.getCity().replaceAll("\u5e02", "");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("account", liBaRequest.getAccount());
        paramMap.put("orderId", orderInfo.getOrderNo());
        paramMap.put("amount", liBaRequest.getAmount());
        paramMap.put("notifyUrl", this.thirdPartyConfigProperties.getServerUrl() + this.thirdPartyConfigProperties.getLiBaCallbackUrl());
        paramMap.put("province", province);
        paramMap.put("city", city);
        String body = libaUtil.createOrder(paramMap);
        if (Objects.isNull(body)) {
            log.error("liba\u8bdd\u8d39\u5145\u503c\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", context);
            return Message.build((boolean)false).setMessage("\u8c03\u7528\u7b2c\u4e09\u65b9\u7535\u8d39\u5145\u503c\u5931\u8d25");
        }
        LiBaBO liBaBO = (LiBaBO)JSON.parseObject((String)body, LiBaBO.class);
        log.info("\u529b\u62d4\u7535\u8d39\u5145\u503c\u4fe1\u606frequest\uff1a{},result:{}", context, (Object)body);
        if (!Objects.equals(liBaBO.getReturnCode(), 200)) {
            return Message.build((boolean)false).setMessage(liBaBO.getReturnMsg());
        }
        LiBaCreateOrderResultBO liBaCreateOrderResultBO = (LiBaCreateOrderResultBO)JSON.parseObject((String)JSON.toJSONString(liBaBO.getData()), LiBaCreateOrderResultBO.class);
        ElectricTopUpResponse response = new ElectricTopUpResponse();
        response.setRequestId(ThreadContext.getRequestId());
        response.setSuccess(Boolean.valueOf(true));
        response.setAccount(liBaCreateOrderResultBO.getAccount());
        response.setAmount(liBaCreateOrderResultBO.getAmount());
        response.setResult(JSON.toJSONString((Object)liBaBO));
        response.setOrderNo(orderInfo.getOrderNo());
        response.setOutOrderNo(liBaRequest.getOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }

    private void remindAccountMoney(BigDecimal balance) {
        if (Objects.nonNull(balance) && balance.compareTo(this.thirdPartyConfigProperties.getAccountBalanceRemind()) <= 0) {
            this.notifyMessageSender.send((NotifyMessage)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)NotifyMessageBuilder.textMessage().title("\u7535\u8d39\u4f59\u989d\u9884\u8b66")).content("\u7535\u8d39\u4f59\u989d\u9884\u8b66\uff1a\u5f53\u524d\u91d1\u989d" + balance + "\n\u8bf7\u53ca\u65f6\u5145\u503c\uff01\uff01\uff01\uff01\uff01\nrequestId:" + ThreadContext.getRequestId() + "")).bindChannel(ChannelBuilder.dingding((String)this.thirdPartyConfigProperties.getDingdingUrl()))).build());
        }
    }
}

