/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment;

import cn.hutool.core.util.ReflectUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.request.PaymentRequest;
import com.google.common.base.Joiner;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IPaymentActionDispatcher<T extends PaymentRequest> {
    private static final Logger log = LoggerFactory.getLogger(IPaymentActionDispatcher.class);
    private Map<String, PayPlatformAction> actionMap = new HashMap<String, PayPlatformAction>();
    private Map<PayPlatformAction, T> classMap = new HashMap<PayPlatformAction, T>();

    @Autowired
    public IPaymentActionDispatcher(List<PayPlatformAction> actionList) {
        for (PayPlatformAction paymentAction : actionList) {
            Method[] methods;
            for (Method method : methods = ReflectUtil.getMethods(paymentAction.getClass())) {
                Class<?>[] parameterTypes;
                if (!Objects.equals(method.getName(), "exec")) continue;
                for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
                    if (Objects.equals(parameterType.getSimpleName(), PaymentRequest.class.getSimpleName())) continue;
                    PaymentRequest newInstance = null;
                    try {
                        parameterType.getConstructor(new Class[0]).setAccessible(true);
                        newInstance = (PaymentRequest)parameterType.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    this.classMap.put(paymentAction, newInstance);
                }
            }
            String key = this.buildKey(paymentAction);
            if (this.actionMap.containsKey(key)) {
                log.error("{}\u5df2\u7ecf\u5b58\u5728,\u5b58\u5728\u91cd\u590d\u5b9a\u4e49", (Object)key);
            }
            this.actionMap.put(key, paymentAction);
        }
    }

    public Message exec(T request) {
        log.info("\u53d1\u8d77\u652f\u4ed8\u52a8\u4f5c:{}", (Object)JSON.toJSONString(request));
        String key = this.buildKey(request);
        PayPlatformAction action = this.actionMap.get(key);
        if (null == action) {
            log.error("\u4e0d\u5b58\u5728[{}]\u5bf9\u5e94\u7684\u652f\u4ed8\u52a8\u4f5c\u5904\u7406", (Object)key);
            return null;
        }
        return action.exec(request);
    }

    public T getMethodParamClass(T t) {
        String key = this.buildKey(t);
        PayPlatformAction action = this.actionMap.get(key);
        if (null == action) {
            log.error("\u4e0d\u5b58\u5728[{}]\u5bf9\u5e94\u7684\u652f\u4ed8\u52a8\u4f5c\u5904\u7406", (Object)key);
            return null;
        }
        return (T)((PaymentRequest)this.classMap.get(action));
    }

    private String buildKey(T request) {
        return Joiner.on((String)":").join((Object)((PaymentRequest)request).getPlatform().name(), (Object)((PaymentRequest)request).getMode().name(), new Object[]{((PaymentRequest)request).getAction().name()});
    }

    private String buildKey(PayPlatformAction paymentAction) {
        return Joiner.on((String)":").join((Object)paymentAction.platform().name(), (Object)paymentAction.matchMode().name(), new Object[]{paymentAction.matchAction().name()});
    }
}

