/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment;

import cn.hutool.core.bean.BeanUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.AbstractThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.adapter.payment.IPaymentActionDispatcher;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.request.PaymentRequest;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.notify.RefundNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.PaymentRefundRequest;
import com.bxm.thirdparty.platform.facade.response.RefundResponse;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import com.bxm.thirdparty.platform.model.entity.PaymentRefundV2Entity;
import com.bxm.thirdparty.platform.model.enums.LegerTypeEnum;
import com.bxm.thirdparty.platform.model.param.LegerLogParam;
import com.bxm.thirdparty.platform.queue.QueueService;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.bo.RequestBodyBO;
import com.bxm.thirdparty.platform.service.LedgerLogService;
import com.bxm.thirdparty.platform.service.PaymentService;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RefundPlatformAction<T extends PaymentRequest>
extends AbstractThirdPartyPlatformAction<PaymentRefundRequest, PaymentRefundV2Entity> {
    private static final Logger log = LoggerFactory.getLogger(RefundPlatformAction.class);
    @Resource
    IPaymentActionDispatcher iPaymentActionDispatcher;
    @Resource
    private PaymentService paymentService;
    @Resource
    private QueueService queueService;
    @Resource
    private LedgerLogService ledgerLogService;

    @Override
    public Message exec(PlatformContext<PaymentRefundRequest, PaymentRefundV2Entity> context) {
        PaymentRefundRequest request = context.getRequest();
        PaymentRefundV2Entity refundV2Entity = context.getOrderInfo();
        PaymentOrderV2Entity paymentOrder = (PaymentOrderV2Entity)JSON.parseObject((String)context.getExtStr(), PaymentOrderV2Entity.class);
        PaymentRequest paymentRequest = new PaymentRequest();
        paymentRequest.setPlatform(PlatformEnum.get(paymentOrder.getPayPlatform()));
        paymentRequest.setAction(PaymentActionEnum.REFUND);
        PaymentRequest methodParamClass = this.iPaymentActionDispatcher.getMethodParamClass(paymentRequest);
        methodParamClass.setPlatform(PlatformEnum.get(paymentOrder.getPayPlatform()));
        methodParamClass.setAction(PaymentActionEnum.REFUND);
        methodParamClass.setRequestOrderNo(refundV2Entity.getRefundOrderNo());
        BeanUtil.copyProperties((Object)request, (Object)methodParamClass, (String[])new String[0]);
        Message exec = this.iPaymentActionDispatcher.exec(methodParamClass);
        log.info("\u9000\u6b3e\u52a8\u4f5c\u7ed3\u675f:{}", (Object)JSON.toJSONString((Object)exec.getParam(CommonConstant.RESULT_DTO)));
        if (exec.isSuccess()) {
            if (Objects.equals((Object)paymentRequest.getPlatform(), (Object)PlatformEnum.ALI)) {
                RefundResponse refundResponse = (RefundResponse)exec.getParam(CommonConstant.RESULT_DTO);
                RefundNotifyResponse refundNotifyResponse = new RefundNotifyResponse();
                refundNotifyResponse.setRequestId(context.getRequestId());
                if (refundResponse.getSuccess().booleanValue()) {
                    this.paymentService.updateRefundOrderSuccess(refundV2Entity.getRefundOrderNo());
                    refundNotifyResponse.setSuccess(Boolean.valueOf(true));
                    refundNotifyResponse.setPaymentOrderNo(paymentOrder.getOrderNo());
                    refundNotifyResponse.setOutOrderNo(paymentOrder.getOutOrderNo());
                    this.ledgerLogService.insertLedgerLog(LegerLogParam.builder().legerTypeEnum(LegerTypeEnum.REFUND).payPlatform(refundV2Entity.getPayPlatform()).accountId(refundV2Entity.getAccountId()).amount(request.getRefundAmount()).build());
                } else {
                    this.paymentService.updateRefundOrderFail(refundV2Entity.getRefundOrderNo(), refundResponse.getErrorMsg());
                    refundNotifyResponse.setSuccess(Boolean.valueOf(false));
                    refundNotifyResponse.setErrorMsg(refundResponse.getErrorMsg());
                }
                this.businessSubmit(context, refundNotifyResponse);
            } else {
                this.paymentService.updateRefundOrderRefundIng(refundV2Entity.getRefundOrderNo());
            }
        } else {
            this.paymentService.updateRefundOrderFail(refundV2Entity.getRefundOrderNo(), exec.getLastMessage());
        }
        return exec;
    }

    private void businessSubmit(PlatformContext<PaymentRefundRequest, PaymentRefundV2Entity> context, RefundNotifyResponse refundNotifyResponse) {
        QueueBO queueBO = new QueueBO();
        queueBO.setApplicationName(context.getRequest().getApplicationName());
        queueBO.setRequestId(context.getRequestId());
        queueBO.setRequestBodyBO(RequestBodyBO.builder().type(context.getNotifyType().name()).result(JSON.toJSONString((Object)refundNotifyResponse)).build());
        this.queueService.submitBusinessNotify(queueBO);
    }

    @Override
    public Class<? extends BaseRequest> support() {
        return PaymentRefundRequest.class;
    }

    @Override
    protected Message mockResult(PlatformContext<PaymentRefundRequest, PaymentRefundV2Entity> context) {
        PaymentRefundV2Entity orderInfo = context.getOrderInfo();
        RefundResponse refundResponse = new RefundResponse();
        refundResponse.setRequestId(context.getRequestId());
        refundResponse.setSuccess(Boolean.valueOf(true));
        refundResponse.setOutOrderNo(orderInfo.getOutOrderNo());
        refundResponse.setPaymentOrderNo(orderInfo.getPaymentOrderNo());
        refundResponse.setRefundOrderNo(orderInfo.getRefundOrderNo());
        RefundNotifyResponse notifyResponse = new RefundNotifyResponse();
        notifyResponse.setSuccess(Boolean.valueOf(true));
        notifyResponse.setPaymentOrderNo(orderInfo.getPaymentOrderNo());
        notifyResponse.setOutOrderNo(orderInfo.getOutOrderNo());
        notifyResponse.setRequestId(context.getRequestId());
        this.submitQueueNotify(context, JSON.toJSONString((Object)notifyResponse));
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)refundResponse);
    }
}

