/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment;

import cn.hutool.core.bean.BeanUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.AbstractThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.adapter.payment.IPaymentActionDispatcher;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.request.PaymentRequest;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.notify.WithdrawNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.WithdrawRequest;
import com.bxm.thirdparty.platform.facade.response.WithdrawResponse;
import com.bxm.thirdparty.platform.model.entity.PaymentWithdrawFlowV2Entity;
import com.bxm.thirdparty.platform.model.enums.LegerTypeEnum;
import com.bxm.thirdparty.platform.model.param.LegerLogParam;
import com.bxm.thirdparty.platform.queue.QueueService;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.bo.RequestBodyBO;
import com.bxm.thirdparty.platform.service.LedgerLogService;
import com.bxm.thirdparty.platform.service.PaymentService;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WithdrawPlatformAction<T extends PaymentRequest>
extends AbstractThirdPartyPlatformAction<WithdrawRequest, PaymentWithdrawFlowV2Entity> {
    private static final Logger log = LoggerFactory.getLogger(WithdrawPlatformAction.class);
    @Resource
    IPaymentActionDispatcher iPaymentActionDispatcher;
    @Resource
    private PaymentService paymentService;
    @Resource
    private QueueService queueService;
    @Resource
    private LedgerLogService ledgerLogService;

    @Override
    public Message exec(PlatformContext<WithdrawRequest, PaymentWithdrawFlowV2Entity> context) {
        PaymentWithdrawFlowV2Entity orderInfo = context.getOrderInfo();
        PaymentRequest paymentRequest = new PaymentRequest();
        paymentRequest.setPlatform(PlatformEnum.get(context.getRequest().getPayPlatform()));
        paymentRequest.setAction(PaymentActionEnum.TRANSFERS);
        paymentRequest.setRequestOrderNo(orderInfo.getWithdrawOrderNo());
        PaymentRequest methodParamClass = this.iPaymentActionDispatcher.getMethodParamClass(paymentRequest);
        methodParamClass.setPlatform(PlatformEnum.get(context.getRequest().getPayPlatform()));
        methodParamClass.setAction(PaymentActionEnum.TRANSFERS);
        methodParamClass.setRequestOrderNo(orderInfo.getWithdrawOrderNo());
        BeanUtil.copyProperties((Object)context.getRequest(), (Object)methodParamClass, (String[])new String[0]);
        Message exec = this.iPaymentActionDispatcher.exec(methodParamClass);
        WithdrawNotifyResponse response = new WithdrawNotifyResponse();
        response.setRequestId(context.getRequestId());
        response.setOrderNo(orderInfo.getWithdrawOrderNo());
        response.setOutOrderNo(context.getRequest().getOrderNo());
        log.info("\u63d0\u73b0\u52a8\u4f5c\u7ed3\u675f:{}", (Object)JSON.toJSONString((Object)exec.getParam(CommonConstant.RESULT_DTO)));
        if (exec.isSuccess()) {
            if (Objects.equals((Object)paymentRequest.getPlatform(), (Object)PlatformEnum.ALI) || Objects.equals((Object)paymentRequest.getPlatform(), (Object)PlatformEnum.WX)) {
                WithdrawResponse withdrawResponse = (WithdrawResponse)exec.getParam(CommonConstant.RESULT_DTO);
                if (withdrawResponse.getSuccess().booleanValue()) {
                    this.paymentService.updateWithdrawOrderSuccess(orderInfo.getWithdrawOrderNo());
                    response.setSuccess(Boolean.valueOf(true));
                    this.ledgerLogService.insertLedgerLog(LegerLogParam.builder().legerTypeEnum(LegerTypeEnum.WITHDRAW).payPlatform(orderInfo.getPayPlatform()).accountId(orderInfo.getAccountId()).amount(orderInfo.getAmount()).build());
                } else {
                    this.paymentService.updateWithdrawOrderFail(orderInfo.getWithdrawOrderNo(), withdrawResponse.getErrorMsg());
                    response.setSuccess(Boolean.valueOf(false));
                    response.setErrorMsg(withdrawResponse.getErrorMsg());
                    response.setErrorTypeEnum(withdrawResponse.getWithdrawErrorTypeEnum().name());
                }
                this.businessSubmit(context, response);
            }
        } else {
            this.paymentService.updateWithdrawOrderFail(orderInfo.getWithdrawOrderNo(), exec.getLastMessage());
            response.setSuccess(Boolean.valueOf(false));
            response.setErrorMsg(exec.getLastMessage());
            this.businessSubmit(context, response);
        }
        return exec;
    }

    private void businessSubmit(PlatformContext<WithdrawRequest, PaymentWithdrawFlowV2Entity> context, WithdrawNotifyResponse response) {
        PaymentWithdrawFlowV2Entity orderInfo = context.getOrderInfo();
        QueueBO queueBO = new QueueBO();
        queueBO.setDelayTime(3);
        queueBO.setApplicationName(context.getRequest().getApplicationName());
        queueBO.setRequestId(orderInfo.getRequestId());
        queueBO.setRequestBodyBO(RequestBodyBO.builder().type(context.getNotifyType().name()).result(JSON.toJSONString((Object)response)).build());
        this.queueService.submitBusinessNotify(queueBO);
    }

    @Override
    public Class<? extends BaseRequest> support() {
        return WithdrawRequest.class;
    }

    @Override
    protected Message mockResult(PlatformContext<WithdrawRequest, PaymentWithdrawFlowV2Entity> context) {
        PaymentWithdrawFlowV2Entity orderInfo = context.getOrderInfo();
        WithdrawResponse response = new WithdrawResponse();
        response.setRequestId(context.getRequestId());
        response.setSuccess(Boolean.valueOf(true));
        response.setOutOrderNo(orderInfo.getOutTrackNo());
        response.setWithdrawOrderNo(orderInfo.getWithdrawOrderNo());
        WithdrawNotifyResponse notifyResponse = new WithdrawNotifyResponse();
        notifyResponse.setSuccess(Boolean.valueOf(true));
        notifyResponse.setOrderNo(orderInfo.getWithdrawOrderNo());
        notifyResponse.setOutOrderNo(orderInfo.getOutTrackNo());
        notifyResponse.setRequestId(context.getRequestId());
        this.submitQueueNotify(context, JSON.toJSONString((Object)notifyResponse));
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }
}

