/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment.refund.wx;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.refund.wx.request.WxRefundRequest;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.response.RefundResponse;
import com.bxm.thirdparty.platform.mapper.PaymentOrderV2Mapper;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundRequest;
import com.github.binarywang.wxpay.bean.result.WxPayRefundResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WxRefundAction
extends PayPlatformAction<WxRefundRequest> {
    private static final Logger log = LoggerFactory.getLogger(WxRefundAction.class);
    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;
    @Resource
    private ThirdPartyConfigProperties partyConfigProperties;
    @Resource
    private PaymentOrderV2Mapper paymentOrderV2Mapper;

    @Override
    public Message exec(WxRefundRequest request) {
        PaymentOrderV2Entity paymentOrderV2Entity = this.paymentOrderV2Mapper.getByOrderNo(request.getOrderNo());
        WxPayService wxPayService = this.paymentConfigFacadeService.getWxClientByAppIdAndMchId(paymentOrderV2Entity.getAppId(), paymentOrderV2Entity.getAccountId());
        if (Objects.isNull(wxPayService)) {
            return Message.build((boolean)false).setMessage("\u652f\u4ed8\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        WxPayRefundRequest refundRequest = new WxPayRefundRequest();
        refundRequest.setTransactionId(paymentOrderV2Entity.getThirdPartyTradeNo());
        refundRequest.setOutRefundNo(request.getRequestOrderNo());
        refundRequest.setTotalFee(BaseWxPayRequest.yuanToFen((String)paymentOrderV2Entity.getAmount().toString()));
        refundRequest.setRefundFee(BaseWxPayRequest.yuanToFen((String)request.getRefundAmount().toString()));
        refundRequest.setAppid(wxPayService.getConfig().getAppId());
        refundRequest.setOpUserId(wxPayService.getConfig().getMchId());
        refundRequest.setNotifyUrl(this.buildNotifyUrl(paymentOrderV2Entity.getAccountId(), request.getRequestOrderNo()));
        try {
            refundRequest.checkAndSign(wxPayService.getConfig());
        }
        catch (WxPayException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Message.build((boolean)false).setMessage("\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
        }
        RefundResponse refundResponse = new RefundResponse();
        refundResponse.setRequestId(ThreadContext.getRequestId());
        try {
            WxPayRefundResult refundResult = wxPayService.refund(refundRequest);
            refundResponse.setResult(JSON.toJSONString((Object)refundResult));
            if (StringUtils.equals((CharSequence)refundResult.getReturnCode(), (CharSequence)"SUCCESS")) {
                refundResponse.setSuccess(Boolean.valueOf(true));
            } else {
                refundResponse.setSuccess(Boolean.valueOf(false));
                refundResponse.setErrorMsg(refundResult.getReturnMsg());
            }
            refundResponse.setOutOrderNo(request.getRefundOrderNo());
            refundResponse.setRefundOrderNo(request.getRequestOrderNo());
            refundResponse.setPaymentOrderNo(paymentOrderV2Entity.getOrderNo());
        }
        catch (WxPayException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Message.build((boolean)false).setMessage(e.getMessage());
        }
        return Message.build((boolean)true).addParam(CommonConstant.RESULT_DTO, (Object)refundResponse);
    }

    private String buildNotifyUrl(String accountId, String refundOrderNo) {
        return this.partyConfigProperties.getServerUrl() + this.partyConfigProperties.getWxRefundCallbackUrl() + "/" + accountId + "/" + refundOrderNo;
    }

    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.REFUND;
    }

    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.WX;
    }
}

