/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.before.payment;

import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentModeEnum;
import com.bxm.thirdparty.platform.before.IBeforeThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PaymentOrderStatusEnum;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.PaymentPreRequest;
import com.bxm.thirdparty.platform.mapper.PaymentOrderV2Mapper;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class BeforePaymentAction
implements IBeforeThirdPartyPlatformAction<PaymentPreRequest, PaymentOrderV2Entity> {
    @Resource
    private PaymentOrderV2Mapper paymentOrderV2Mapper;
    @Resource
    private SequenceCreater sequenceCreater;

    @Override
    public Class<?> support() {
        return PaymentPreRequest.class;
    }

    @Override
    public Message validationArgs(PlatformContext<PaymentPreRequest, PaymentOrderV2Entity> context) {
        PaymentPreRequest request = context.getRequest();
        String payPlatform = request.getPayPlatform();
        String payMode = request.getPayMode();
        if (Objects.isNull(payPlatform)) {
            return Message.build((boolean)false).setMessage("\u8bf7\u6307\u5b9a\u652f\u4ed8\u5e73\u53f0");
        }
        if (Objects.isNull(request.getAmount()) || Objects.isNull(request.getAccountId()) || Objects.isNull(request.getTitle()) || Objects.isNull(request.getOrderDescription())) {
            return Message.build((boolean)false).setMessage("\u53c2\u6570\u7f3a\u5931");
        }
        if (Objects.equals(payPlatform, PlatformEnum.WX.name()) && Objects.equals(payMode, PaymentModeEnum.APPLET.name()) && (Objects.isNull(request.getAppId()) || Objects.isNull(request.getOpenId()))) {
            return Message.build((boolean)false).setMessage("\u5c0f\u7a0b\u5e8f\u652f\u4ed8\u9700\u8981appId\u548copenID");
        }
        List<String> platformListByBusinessType = PlatformEnum.getPlatformListByBusinessType(PlatformBusinessTypeEnum.PAYMENT);
        if (!platformListByBusinessType.contains(payPlatform)) {
            return Message.build((boolean)false).setMessage(payPlatform + "\u652f\u4ed8\u5e73\u53f0\u6682\u672a\u5b9e\u73b0");
        }
        context.setMock(request.getMock());
        context.setSync(Boolean.TRUE);
        return Message.build();
    }

    @Override
    public void insertInfo(PlatformContext<PaymentPreRequest, PaymentOrderV2Entity> context) {
        PaymentPreRequest request = context.getRequest();
        PaymentOrderV2Entity paymentOrderV2Entity = new PaymentOrderV2Entity();
        paymentOrderV2Entity.setId(this.sequenceCreater.nextLongId());
        paymentOrderV2Entity.setApplicationName(request.getApplicationName());
        paymentOrderV2Entity.setPayPlatform(request.getPayPlatform());
        paymentOrderV2Entity.setPayMode(request.getPayMode());
        paymentOrderV2Entity.setTitle(request.getTitle());
        paymentOrderV2Entity.setDescription(request.getOrderDescription());
        paymentOrderV2Entity.setOrderNo(SequenceHolder.nextStringId());
        paymentOrderV2Entity.setOutOrderNo(request.getOrderNo());
        paymentOrderV2Entity.setAmount(request.getAmount());
        paymentOrderV2Entity.setStatus(Integer.valueOf(PaymentOrderStatusEnum.WAIT.getCode()));
        paymentOrderV2Entity.setMockOrder(Integer.valueOf(request.getMock() != false ? 1 : 0));
        paymentOrderV2Entity.setRequestIp(request.getRequestIp());
        paymentOrderV2Entity.setCreateTime(new Date());
        paymentOrderV2Entity.setAppId(request.getAppId());
        paymentOrderV2Entity.setAccountId(request.getAccountId());
        paymentOrderV2Entity.setRequestId(ThreadContext.getRequestId());
        this.paymentOrderV2Mapper.insert((Object)paymentOrderV2Entity);
        context.setOrderInfo(paymentOrderV2Entity);
    }
}

