/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.before.refund;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.before.IBeforeThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PaymentOrderStatusEnum;
import com.bxm.thirdparty.platform.enums.PaymentRefundStatusEnum;
import com.bxm.thirdparty.platform.facade.request.PaymentRefundRequest;
import com.bxm.thirdparty.platform.mapper.PaymentOrderV2Mapper;
import com.bxm.thirdparty.platform.mapper.PaymentRefundV2Mapper;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import com.bxm.thirdparty.platform.model.entity.PaymentRefundV2Entity;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BeforeRefundAction
implements IBeforeThirdPartyPlatformAction<PaymentRefundRequest, PaymentRefundV2Entity> {
    private static final Logger log = LoggerFactory.getLogger(BeforeRefundAction.class);
    @Resource
    private PaymentOrderV2Mapper paymentOrderV2Mapper;
    @Resource
    private PaymentRefundV2Mapper paymentRefundV2Mapper;
    @Resource
    private SequenceCreater sequenceCreater;

    @Override
    public Class<?> support() {
        return PaymentRefundRequest.class;
    }

    @Override
    public Message validationArgs(PlatformContext<PaymentRefundRequest, PaymentRefundV2Entity> context) {
        PaymentRefundRequest request = context.getRequest();
        String orderNo = request.getOrderNo();
        String outTrackNo = request.getOutTrackNo();
        if (StringUtils.isBlank((CharSequence)orderNo) && StringUtils.isBlank((CharSequence)outTrackNo)) {
            return Message.build((boolean)false).setMessage("\u8ba2\u5355\u53f7,\u548c\u5185\u90e8\u5c01\u88c5\u670d\u52a1\u8ba2\u5355\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002");
        }
        PaymentOrderV2Entity orderV2Entity = this.getPaymentOrder(context);
        if (orderV2Entity == null) {
            return Message.build((boolean)false).setMessage("\u672a\u67e5\u8be2\u5230\u652f\u4ed8\u6210\u529f\u7684\u8ba2\u5355\u4fe1\u606f");
        }
        if (Objects.equals(orderV2Entity.getMockOrder(), 1)) {
            return Message.build((boolean)false).setMessage("mock\u8ba2\u5355\u4e0d\u652f\u6301\u9000\u6b3e");
        }
        if (Objects.isNull(request.getRefundAmount())) {
            request.setRefundAmount(orderV2Entity.getAmount());
        }
        if (orderV2Entity.getAmount().compareTo(request.getRefundAmount()) < 0) {
            return Message.build((boolean)false).setMessage("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u652f\u4ed8\u8ba2\u5355\u91d1\u989d");
        }
        PaymentRefundV2Entity refundV2Entity = this.paymentRefundV2Mapper.getByPaymentOrderNo(orderV2Entity.getOrderNo());
        if (Objects.nonNull(refundV2Entity) && (Objects.equals(PaymentRefundStatusEnum.REFUND_ING.getCode(), refundV2Entity.getStatus()) || Objects.equals(PaymentRefundStatusEnum.REFUNDED.getCode(), refundV2Entity.getStatus()))) {
            log.warn("\u8ba2\u5355[{}]\u5df2\u9000\u6b3e\u6216\u6b63\u5728\u9000\u6b3e\uff0c\u4e0d\u4e88\u91cd\u590d\u5904\u7406", (Object)orderNo);
            return Message.build((boolean)false, (String)"\u9000\u6b3e\u5904\u7406\u4e2d\u6216\u5df2\u5904\u7406");
        }
        Integer status = orderV2Entity.getStatus();
        if (PaymentOrderStatusEnum.REFUND_ING.match(status) || PaymentOrderStatusEnum.REFUNDED.match(status)) {
            log.warn("\u4e1a\u52a1\u8ba2\u5355[{}]\u5904\u4e8e\u9000\u6b3e\u4e2d\u6216\u5df2\u9000\u6b3e\u72b6\u6001\uff0c\u4ecd\u7136\u88ab\u8c03\u7528", (Object)orderNo);
            return Message.build((boolean)false, (String)"\u8ba2\u5355\u5df2\u9000\u6b3e\u6216\u6b63\u5728\u9000\u6b3e\u4e2d");
        }
        if (!PaymentOrderStatusEnum.SUCCESS.match(status) && !PaymentOrderStatusEnum.REFUND_FAIL.match(status)) {
            log.warn("\u4e1a\u52a1\u8ba2\u5355[{}]\u5f53\u524d\u5904\u4e8e[{}],\u4e0d\u652f\u6301\u9000\u6b3e", (Object)orderNo, (Object)status);
            return Message.build((boolean)false, (String)"\u8ba2\u5355\u4e0d\u5904\u7406\u652f\u4ed8\u6210\u529f\u7684\u72b6\u6001\uff0c\u65e0\u6cd5\u9000\u6b3e");
        }
        request.setOrderNo(orderV2Entity.getOrderNo());
        context.setExtStr(JSON.toJSONString((Object)orderV2Entity));
        context.setMock(orderV2Entity.getMockOrder() == 1);
        context.setSync(Boolean.TRUE);
        return Message.build();
    }

    private PaymentOrderV2Entity getPaymentOrder(PlatformContext context) {
        PaymentRefundRequest request = (PaymentRefundRequest)context.getRequest();
        String orderNo = request.getOrderNo();
        PaymentOrderV2Entity orderV2Entity = null;
        if (StringUtils.isNotBlank((CharSequence)orderNo)) {
            orderV2Entity = this.paymentOrderV2Mapper.getByOrderNo(orderNo);
        } else {
            List paymentOrderV2Entities = this.paymentOrderV2Mapper.getByOutOrderNo(request.getOutTrackNo());
            if (paymentOrderV2Entities.size() > 1) {
                log.warn("\u4e1a\u52a1\u8ba2\u5355\u53f7[{}]\u5bf9\u5e94\u7684\u8ba2\u5355\u6709\u591a\u6761", (Object)request.getOutTrackNo());
            }
            Optional<PaymentOrderV2Entity> paymentOrderV2EntityOptional = paymentOrderV2Entities.stream().filter(paymentOrderV2Entity -> Objects.equals(PaymentOrderStatusEnum.SUCCESS.getCode(), paymentOrderV2Entity.getStatus())).findFirst();
            orderV2Entity = paymentOrderV2EntityOptional.orElse(null);
        }
        return orderV2Entity;
    }

    @Override
    public void insertInfo(PlatformContext<PaymentRefundRequest, PaymentRefundV2Entity> context) {
        PaymentRefundRequest request = context.getRequest();
        PaymentOrderV2Entity paymentOrder = (PaymentOrderV2Entity)JSON.parseObject((String)context.getExtStr(), PaymentOrderV2Entity.class);
        PaymentRefundV2Entity historyInfo = this.paymentRefundV2Mapper.getByPaymentOrderNo(paymentOrder.getOrderNo());
        PaymentRefundV2Entity refundV2Entity = new PaymentRefundV2Entity();
        refundV2Entity.setId(this.sequenceCreater.nextLongId());
        refundV2Entity.setPayPlatform(paymentOrder.getPayPlatform());
        refundV2Entity.setAccountId(paymentOrder.getAccountId());
        refundV2Entity.setApplicationName(paymentOrder.getApplicationName());
        refundV2Entity.setAmount(paymentOrder.getAmount());
        refundV2Entity.setStatus(Integer.valueOf(0));
        refundV2Entity.setRemark(paymentOrder.getRemark());
        refundV2Entity.setPaymentOrderNo(paymentOrder.getOrderNo());
        refundV2Entity.setRefundOrderNo(SequenceHolder.nextStringId());
        refundV2Entity.setCreateTime(new Date());
        refundV2Entity.setOutOrderNo(request.getRefundOrderNo());
        refundV2Entity.setRequestId(ThreadContext.getRequestId());
        if (Objects.nonNull(historyInfo)) {
            refundV2Entity.setId(historyInfo.getId());
            this.paymentRefundV2Mapper.updateById((Object)refundV2Entity);
        } else {
            this.paymentRefundV2Mapper.insert((Object)refundV2Entity);
        }
        context.setOrderInfo(refundV2Entity);
    }
}

