/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.callback.gongmao;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.callback.IPlatformCallbackAction;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.callback.gongmao.enums.GongMaoStatusEnum;
import com.bxm.thirdparty.platform.callback.param.GongMaoCallbackParam;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.facade.notify.ChargePhoneNotifyResponse;
import com.bxm.thirdparty.platform.facade.notify.ElectricNotifyResponse;
import com.bxm.thirdparty.platform.mapper.ChargesPhoneLogMapper;
import com.bxm.thirdparty.platform.mapper.ElectricLogMapper;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GongMaoCallbackAction
implements IPlatformCallbackAction {
    private static final Logger log = LoggerFactory.getLogger(GongMaoCallbackAction.class);
    @Resource
    private ChargesPhoneLogMapper chargesPhoneLogMapper;
    @Resource
    private ElectricLogMapper electricLogMapper;
    @Resource
    private ThirdPartyConfigProperties thirdPartyConfigProperties;

    @Override
    public Class<?> support() {
        return GongMaoCallbackParam.class;
    }

    public Message execCallback(PlatformCallbackContext context) {
        GongMaoCallbackParam param = (GongMaoCallbackParam)context.getCallbackParam();
        if (Objects.equals(PlatformBusinessTypeEnum.ELECTRIC.name(), param.getType())) {
            return this.handlerElectric(context);
        }
        if (Objects.equals(PlatformBusinessTypeEnum.CHARGE_PHONE.name(), param.getType())) {
            return this.handlerChargePhone(context);
        }
        return Message.build((boolean)false).setMessage("\u672a\u77e5\u7684\u7c7b\u578b");
    }

    private Message handlerChargePhone(PlatformCallbackContext context) {
        GongMaoCallbackParam param = (GongMaoCallbackParam)context.getCallbackParam();
        ChargesPhoneLogEntity chargesPhoneLogEntity = (ChargesPhoneLogEntity)context.getOrderInfo();
        ChargesPhoneLogEntity updateClass = new ChargesPhoneLogEntity();
        updateClass.setStatus(param.getStatus());
        updateClass.setId(chargesPhoneLogEntity.getId());
        updateClass.setModifyTime(new Date());
        updateClass.setErrorMsg(param.getFailReason());
        this.chargesPhoneLogMapper.updateById((Object)updateClass);
        ChargePhoneNotifyResponse response = new ChargePhoneNotifyResponse();
        response.setRequestId(context.getRequestId());
        if (Objects.equals(param.getStatus(), GongMaoStatusEnum.SUCCESS.getStatus())) {
            response.setSuccess(Boolean.valueOf(true));
        } else {
            response.setSuccess(Boolean.valueOf(false));
            response.setErrorMsg(param.getFailReason());
        }
        response.setOrderNo(chargesPhoneLogEntity.getOrderNo());
        response.setOutOrderNo(chargesPhoneLogEntity.getOutOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }

    private Message handlerElectric(PlatformCallbackContext context) {
        GongMaoCallbackParam param = (GongMaoCallbackParam)context.getCallbackParam();
        ElectricLogEntity electricLogEntity = (ElectricLogEntity)context.getOrderInfo();
        ElectricLogEntity updateClass = new ElectricLogEntity();
        updateClass.setId(electricLogEntity.getId());
        updateClass.setStatus(param.getStatus());
        updateClass.setModifyTime(new Date());
        updateClass.setErrorMsg(param.getFailReason());
        this.electricLogMapper.updateById((Object)updateClass);
        ElectricNotifyResponse response = new ElectricNotifyResponse();
        response.setRequestId(context.getRequestId());
        if (Objects.equals(param.getStatus(), GongMaoStatusEnum.SUCCESS.getStatus())) {
            response.setSuccess(Boolean.valueOf(true));
            if (param.getSuccessPrice() != null) {
                BigDecimal costRate = this.thirdPartyConfigProperties.getSouthElectric().contains(electricLogEntity.getProvince()) ? this.thirdPartyConfigProperties.getGongMaoElectricSouthCostRate() : this.thirdPartyConfigProperties.getGongMaoElectricCostRate();
                BigDecimal molecule = param.getSuccessPrice();
                BigDecimal denominator = costRate;
                BigDecimal divide = molecule.divide(denominator, 2, RoundingMode.UP);
                response.setSuccessAmount(divide);
            }
        } else {
            response.setSuccess(Boolean.valueOf(false));
            response.setErrorMsg(param.getFailReason());
        }
        response.setOrderNo(electricLogEntity.getOrderNo());
        response.setOutOrderNo(electricLogEntity.getOutOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }
}

