/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.callback.xinrong;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.enums.XinRongStatusEnum;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.utils.XinRongUtil;
import com.bxm.thirdparty.platform.callback.IPlatformCallbackAction;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.callback.param.XinRongChargePhoneParam;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.facade.notify.ChargePhoneNotifyResponse;
import com.bxm.thirdparty.platform.mapper.ChargesPhoneLogMapper;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XinRongCallbackAction
implements IPlatformCallbackAction {
    private static final Logger log = LoggerFactory.getLogger(XinRongCallbackAction.class);
    @Resource
    private ChargesPhoneLogMapper chargesPhoneLogMapper;
    @Resource
    private ThirdPartyConfigProperties thirdPartyConfigProperties;

    @Override
    public Class<?> support() {
        return XinRongChargePhoneParam.class;
    }

    public Message execCallback(PlatformCallbackContext context) {
        XinRongChargePhoneParam xinRongChargePhoneParam = (XinRongChargePhoneParam)context.getCallbackParam();
        ChargesPhoneLogEntity chargesPhoneLogEntity = (ChargesPhoneLogEntity)context.getOrderInfo();
        if (!Objects.equals(chargesPhoneLogEntity.getStatus(), XinRongStatusEnum.WAITING.getStatus())) {
            log.error("\u5fc3\u878d\u56de\u8c03\u4fe1\u606f\u5df2\u5904\u7406\uff1a{}", (Object)context);
            return Message.build((boolean)false);
        }
        XinRongUtil xinRongUtil = new XinRongUtil(this.thirdPartyConfigProperties);
        BigDecimal sellMoney = xinRongUtil.getSellMoney(chargesPhoneLogEntity.getApplicationName(), xinRongChargePhoneParam.getOut_logno(), xinRongChargePhoneParam.getLogno());
        ChargesPhoneLogEntity updateClass = new ChargesPhoneLogEntity();
        updateClass.setThirdPartyTrackNo(xinRongChargePhoneParam.getLogno());
        updateClass.setStatus(xinRongChargePhoneParam.getStatus());
        updateClass.setId(chargesPhoneLogEntity.getId());
        updateClass.setModifyTime(new Date());
        updateClass.setErrorMsg(xinRongChargePhoneParam.getMsg());
        updateClass.setSellMoney(sellMoney);
        this.chargesPhoneLogMapper.updateById((Object)updateClass);
        ChargePhoneNotifyResponse response = new ChargePhoneNotifyResponse();
        response.setRequestId(context.getRequestId());
        if (Objects.equals(xinRongChargePhoneParam.getStatus(), XinRongStatusEnum.SUCCESS.getStatus())) {
            response.setSuccess(Boolean.valueOf(true));
            response.setSellMoney(sellMoney);
        } else {
            response.setSuccess(Boolean.valueOf(false));
            response.setErrorMsg(xinRongChargePhoneParam.getMsg());
        }
        response.setOrderNo(chargesPhoneLogEntity.getOrderNo());
        response.setOutOrderNo(chargesPhoneLogEntity.getOutOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }
}

