/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.queue;

import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.bxm.thirdparty.platform.config.ServerNotifyProperties;
import com.bxm.thirdparty.platform.queue.QueueManage;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class NotifyQueueExecutor
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(NotifyQueueExecutor.class);
    private ThreadPoolTaskExecutor taskExecutor;
    private AtomicInteger runningCounter = new AtomicInteger(0);
    private final ServerNotifyProperties properties;
    private final QueueManage queueManage;

    public NotifyQueueExecutor(ServerNotifyProperties properties, QueueManage queueManage) {
        this.properties = properties;
        this.queueManage = queueManage;
    }

    public boolean isFullLoad() {
        return this.runningCounter.get() <= 0;
    }

    public void run(ApplicationArguments args) throws Exception {
        if (this.properties.getQueueExecutorNum() <= 0) {
            throw new IllegalArgumentException("notify.config.queueExecutorNum\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        String namePrefix = "notify-queue-task";
        this.taskExecutor = new ThreadPoolTaskExecutor();
        this.taskExecutor.setMaxPoolSize(this.properties.getQueueExecutorNum());
        this.taskExecutor.setCorePoolSize(this.properties.getQueueExecutorNum());
        this.taskExecutor.setThreadFactory((ThreadFactory)new NamedThreadFactory(namePrefix, false));
        this.taskExecutor.setQueueCapacity(500);
        this.taskExecutor.setRejectedExecutionHandler((r, executor) -> {
            log.error("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff0c\u8d85\u8fc7\u5bb9\u91cf\u9650\u5236");
            r.run();
        });
        this.taskExecutor.initialize();
        this.runningCounter = new AtomicInteger(this.properties.getQueueExecutorNum());
    }

    public void executor(QueueBO queueBO) {
        this.taskExecutor.execute(() -> {
            this.runningCounter.decrementAndGet();
            try {
                this.queueManage.notifyBusiness(queueBO);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.runningCounter.incrementAndGet();
            }
        });
    }
}

