/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.service.impl;

import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.thirdparty.platform.cache.RelationApplicationRedisKey;
import com.bxm.thirdparty.platform.facade.request.RegisterNotifyParam;
import com.bxm.thirdparty.platform.mapper.BusinessNotifyRelationMapper;
import com.bxm.thirdparty.platform.model.entity.BusinessNotifyRelationEntity;
import com.bxm.thirdparty.platform.service.ApplicationRelationService;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApplicationRelationServiceImpl
implements ApplicationRelationService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationRelationServiceImpl.class);
    private final BusinessNotifyRelationMapper businessNotifyRelationMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public Boolean registerNotify(RegisterNotifyParam param) {
        BusinessNotifyRelationEntity notifyRelationEntity = this.businessNotifyRelationMapper.getByApplication(param.getApplicationName());
        if (Objects.isNull(notifyRelationEntity)) {
            notifyRelationEntity = new BusinessNotifyRelationEntity();
            notifyRelationEntity.setApplication(param.getApplicationName());
            notifyRelationEntity.setNotifyUrl(param.getNotifyUrl());
            notifyRelationEntity.setCreateTime(new Date());
            this.businessNotifyRelationMapper.insert((Object)notifyRelationEntity);
            this.redisHashMapAdapter.put(RelationApplicationRedisKey.APPLICATION_NOTIFY_KEY.copy(), param.getApplicationName(), (Object)param.getNotifyUrl());
            return Boolean.TRUE;
        }
        if (!Objects.equals(param.getNotifyUrl(), notifyRelationEntity.getNotifyUrl())) {
            Integer id = notifyRelationEntity.getId();
            notifyRelationEntity = new BusinessNotifyRelationEntity();
            notifyRelationEntity.setId(id);
            notifyRelationEntity.setApplication(param.getApplicationName());
            notifyRelationEntity.setNotifyUrl(param.getNotifyUrl());
            notifyRelationEntity.setModifyTime(new Date());
            this.businessNotifyRelationMapper.updateById((Object)notifyRelationEntity);
            this.redisHashMapAdapter.put(RelationApplicationRedisKey.APPLICATION_NOTIFY_KEY.copy(), param.getApplicationName(), (Object)param.getNotifyUrl());
        }
        return Boolean.TRUE;
    }

    @Override
    public String getNotifyUrl(String applicationName) {
        return (String)this.redisHashMapAdapter.get(RelationApplicationRedisKey.APPLICATION_NOTIFY_KEY.copy(), applicationName, String.class);
    }

    public ApplicationRelationServiceImpl(BusinessNotifyRelationMapper businessNotifyRelationMapper, RedisHashMapAdapter redisHashMapAdapter) {
        this.businessNotifyRelationMapper = businessNotifyRelationMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }
}

