/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.service.impl;

import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.thirdparty.platform.mapper.LedgerLogMapper;
import com.bxm.thirdparty.platform.model.entity.LedgerLogEntity;
import com.bxm.thirdparty.platform.model.param.LegerLogParam;
import com.bxm.thirdparty.platform.service.LedgerLogService;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LedgerLogServiceImpl
implements LedgerLogService {
    private static final Logger log = LoggerFactory.getLogger(LedgerLogServiceImpl.class);
    private final LedgerLogMapper ledgerLogMapper;

    @Override
    public void insertLedgerLog(LegerLogParam legerLogParam) {
        LedgerLogEntity ledgerLogEntity = new LedgerLogEntity();
        ledgerLogEntity.setId(SequenceHolder.nextLongId());
        ledgerLogEntity.setAccountId(legerLogParam.getAccountId());
        ledgerLogEntity.setPlatform(legerLogParam.getPayPlatform());
        ledgerLogEntity.setAmount(legerLogParam.getAmount());
        ledgerLogEntity.setType(legerLogParam.getLegerTypeEnum().name());
        ledgerLogEntity.setTypeMsg(legerLogParam.getLegerTypeEnum().getDesc());
        ledgerLogEntity.setCreateTime(LocalDateTime.now());
        this.ledgerLogMapper.insert((Object)ledgerLogEntity);
    }

    public LedgerLogServiceImpl(LedgerLogMapper ledgerLogMapper) {
        this.ledgerLogMapper = ledgerLogMapper;
    }
}

