/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.service.impl;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.bxm.newidea.component.notify.NotifyMessageSender;
import com.bxm.newidea.component.notify.channel.ChannelBuilder;
import com.bxm.newidea.component.notify.message.NotifyMessage;
import com.bxm.newidea.component.notify.message.NotifyMessageBuilder;
import com.bxm.newidea.component.notify.message.TextNotifyMessage;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.mapper.ThirdPartyFailLogMapper;
import com.bxm.thirdparty.platform.model.entity.ThirdPartyFailLogEntity;
import com.bxm.thirdparty.platform.queue.notifybusiness.enums.NotifyStatusEnum;
import com.bxm.thirdparty.platform.service.ThirdPartyFailService;
import com.bxm.thirdparty.platform.service.impl.bo.ThirdPartyFailBO;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThirdPartyFailServiceImpl
implements ThirdPartyFailService {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyFailServiceImpl.class);
    private final ThirdPartyFailLogMapper thirdPartyFailLogMapper;
    private final ThirdPartyConfigProperties thirdPartyConfigProperties;
    private final NotifyMessageSender notifyMessageSender;

    @Override
    public void submitThirdPartyFailLog(ThirdPartyFailBO thirdPartyFailBO) {
        ThirdPartyFailLogEntity thirdPartyFailLogEntity = this.thirdPartyFailLogMapper.getByRequestId(thirdPartyFailBO.getRequestId());
        if (Objects.isNull(thirdPartyFailLogEntity)) {
            int nextInterval = this.thirdPartyConfigProperties.getRetryIntervalArray()[0];
            DateTime offset = DateUtil.offset((Date)new Date(), (DateField)DateField.SECOND, (int)nextInterval);
            thirdPartyFailLogEntity = new ThirdPartyFailLogEntity();
            thirdPartyFailLogEntity.setId(SequenceHolder.nextLongId());
            thirdPartyFailLogEntity.setParamDto(thirdPartyFailBO.getParam());
            thirdPartyFailLogEntity.setRequestId(thirdPartyFailBO.getRequestId());
            thirdPartyFailLogEntity.setFailNum(Integer.valueOf(1));
            thirdPartyFailLogEntity.setPlatform(thirdPartyFailBO.getTypeEnum().name());
            thirdPartyFailLogEntity.setCreateTime(new Date());
            thirdPartyFailLogEntity.setNextRetryTime(offset.toJdkDate());
            thirdPartyFailLogEntity.setStatus(Integer.valueOf(NotifyStatusEnum.WAIT_ING.getStatus()));
            thirdPartyFailLogEntity.setErrorMsg(thirdPartyFailBO.getErrorMsg());
            this.thirdPartyFailLogMapper.insert((Object)thirdPartyFailLogEntity);
        } else {
            if (thirdPartyFailLogEntity.getFailNum() + 1 >= this.thirdPartyConfigProperties.getRetryIntervalArray().length) {
                log.error("\u7b2c\u4e09\u65b9\u670d\u52a1[{}]\u91cd\u8bd5\u6b21\u6570\u8fbe\u5230[{}]\u6b21\uff0crequestId:{},\u76f4\u63a5\u8bb0\u5f55\u4e3a\u5931\u8d25,\u6700\u8fd1\u4e00\u6b21\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a{}", new Object[]{thirdPartyFailLogEntity.getPlatform(), thirdPartyFailLogEntity.getFailNum(), thirdPartyFailLogEntity.getRequestId(), thirdPartyFailBO.getErrorMsg()});
                this.notifyMessageSender.send((NotifyMessage)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)((TextNotifyMessage.TextNotifyMessageBuilder)NotifyMessageBuilder.textMessage().title("\u7b2c\u4e09\u65b9\u670d\u52a1\u5931\u8d25\u901a\u77e5")).content("\u7b2c\u4e09\u65b9\u670d\u52a1\u5931\u8d25\u901a\u77e5\uff1a\u91cd\u8bd5\u7c7b\u578b\u4e3a" + thirdPartyFailLogEntity.getPlatform() + "\n\u6700\u540e\u4e00\u6b21\u5931\u8d25\u8fd4\u56de\u4fe1\u606f\uff1a" + thirdPartyFailBO.getErrorMsg() + "\nrequestId:" + thirdPartyFailLogEntity.getRequestId() + "")).bindChannel(ChannelBuilder.dingding((String)this.thirdPartyConfigProperties.getDingdingUrl()))).build());
                return;
            }
            Integer failNum = thirdPartyFailLogEntity.getFailNum() + 1;
            int nextInterval = this.thirdPartyConfigProperties.getRetryIntervalArray()[thirdPartyFailLogEntity.getFailNum()];
            DateTime offset = DateUtil.offset((Date)new Date(), (DateField)DateField.SECOND, (int)nextInterval);
            ThirdPartyFailLogEntity updateClass = new ThirdPartyFailLogEntity();
            updateClass.setId(thirdPartyFailLogEntity.getId());
            updateClass.setNextRetryTime(offset.toJdkDate());
            updateClass.setStatus(Integer.valueOf(NotifyStatusEnum.WAIT_ING.getStatus()));
            updateClass.setFailNum(failNum);
            updateClass.setErrorMsg(thirdPartyFailBO.getErrorMsg());
            this.thirdPartyFailLogMapper.updateById((Object)updateClass);
        }
    }

    @Override
    public void updateThirdPartySuccess(String requestId) {
        ThirdPartyFailLogEntity thirdPartyFailLogEntity = this.thirdPartyFailLogMapper.getByRequestId(requestId);
        if (Objects.isNull(thirdPartyFailLogEntity)) {
            log.error("requestId\uff1a{}\u7b2c\u4e09\u65b9\u91cd\u8bd5\u6210\u529f\uff0c\u4f46\u672a\u67e5\u8be2\u5230\u901a\u77e5\u4fe1\u606f", (Object)requestId);
            return;
        }
        ThirdPartyFailLogEntity updateClass = new ThirdPartyFailLogEntity();
        updateClass.setId(thirdPartyFailLogEntity.getId());
        updateClass.setStatus(Integer.valueOf(NotifyStatusEnum.SUCCESS.getStatus()));
        this.thirdPartyFailLogMapper.updateById((Object)updateClass);
    }

    @Override
    public void platformRetry() {
    }

    public ThirdPartyFailServiceImpl(ThirdPartyFailLogMapper thirdPartyFailLogMapper, ThirdPartyConfigProperties thirdPartyConfigProperties, NotifyMessageSender notifyMessageSender) {
        this.thirdPartyFailLogMapper = thirdPartyFailLogMapper;
        this.thirdPartyConfigProperties = thirdPartyConfigProperties;
        this.notifyMessageSender = notifyMessageSender;
    }
}

