/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.timer;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.schedule.AbstractCronXxlJob;
import com.bxm.thirdparty.platform.mapper.BusinessNotifyLogMapper;
import com.bxm.thirdparty.platform.model.entity.BusinessNotifyLogEntity;
import com.bxm.thirdparty.platform.queue.NotifyQueueCacheHolder;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AddBusinessNotifyTask
extends AbstractCronXxlJob {
    private static final Logger log = LoggerFactory.getLogger(AddBusinessNotifyTask.class);
    @Resource
    private BusinessNotifyLogMapper notifyLogMapper;
    @Resource
    private NotifyQueueCacheHolder cacheHolder;
    private static final int LIMIT = 100;

    public void executeLogic() {
        this.loop(0L);
    }

    private void loop(Long lastRecordId) {
        List readyList = this.notifyLogMapper.queryReadyItemList(lastRecordId, Integer.valueOf(100));
        for (BusinessNotifyLogEntity entity : readyList) {
            String request = entity.getRequest();
            QueueBO queueBO = (QueueBO)JSON.parseObject((String)request, QueueBO.class);
            BusinessNotifyLogEntity updateClass = new BusinessNotifyLogEntity();
            updateClass.setId(entity.getId());
            updateClass.setStatus(Integer.valueOf(1));
            updateClass.setModifyTime(new Date());
            this.notifyLogMapper.updateById((Object)updateClass);
            this.cacheHolder.addToQueue(queueBO);
        }
        if (readyList.size() >= 100) {
            this.loop(((BusinessNotifyLogEntity)readyList.get(readyList.size() - 1)).getId());
        }
    }

    protected String cron() {
        return "0/5 * * * * ?";
    }

    public String jobDesc() {
        return "\u6267\u884c\u4e1a\u52a1\u901a\u77e5";
    }

    public String author() {
        return "lowi";
    }
}

