/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.timer;

import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.schedule.AbstractCronXxlJob;
import com.bxm.thirdparty.platform.model.entity.ThirdPartyFailLogEntity;
import com.bxm.thirdparty.platform.service.ThirdPartyFailService;
import com.bxm.thirdparty.platform.thirdpartyretry.ThirdPartyFailCacheHolder;
import com.bxm.thirdparty.platform.thirdpartyretry.strategy.ThirdPartyRetryManage;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ThirdPartyRetryTask
extends AbstractCronXxlJob {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyRetryTask.class);
    @Resource
    private ThirdPartyFailCacheHolder thirdPartyFailCacheHolder;
    @Resource
    private ThirdPartyRetryManage thirdPartyRetryManage;
    @Resource
    private ThirdPartyFailService thirdPartyFailService;

    public void executeLogic() {
        this.loopFetch();
    }

    private void loopFetch() {
        ThirdPartyFailLogEntity pop = this.thirdPartyFailCacheHolder.pop();
        if (pop != null) {
            Message message = this.thirdPartyRetryManage.execRetry(pop);
            if (message.isSuccess()) {
                this.thirdPartyFailService.updateThirdPartySuccess(pop.getRequestId());
            }
            this.loopFetch();
        }
    }

    protected String cron() {
        return "0/5 * * * * ?";
    }

    public String jobDesc() {
        return "\u6267\u884c\u4e1a\u52a1\u901a\u77e5";
    }

    public String author() {
        return "lowi";
    }
}

