/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.utils;

import cn.hutool.core.util.IdUtil;
import com.bxm.thirdparty.platform.context.ThreadContext;
import org.slf4j.MDC;

public class TraceUtil {
    public static void traceStart() {
        String clientIp = ThreadContext.getClientIp();
        ThreadContext.init();
        String requestId = TraceUtil.generateRequestId();
        MDC.put((String)"requestIdKey", (String)requestId);
        MDC.put((String)"clientIp", (String)clientIp);
        ThreadContext.putRequestId(requestId);
    }

    public static void traceEnd() {
        MDC.clear();
        ThreadContext.clean();
    }

    public static void synReplaceRequestId(String requestId) {
        MDC.put((String)"requestIdKey", (String)requestId);
        ThreadContext.putRequestId(requestId);
    }

    public static void asynReplaceRequestId(String requestId) {
        ThreadContext.init();
        MDC.put((String)"requestIdKey", (String)requestId);
        ThreadContext.putRequestId(requestId);
    }

    private static String generateRequestId() {
        return IdUtil.randomUUID();
    }
}

