package com.bxm.foundation.user.facade;

import com.bxm.foundation.user.facade.bo.UserRiskJudgeResultBO;
import com.bxm.foundation.user.facade.param.RiskUserParam;

/**
 * 基础风控相关的内部服务接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/7/28 11:21 上午
 */
public interface RiskUserFacadeService {

    /**
     * 添加为风险用户
     *
     * @param riskUserParam 风险用户入参
     */
    void addRiskUser(RiskUserParam riskUserParam);

    /**
     * 判断用户是否是一个风险用户
     *
     * @param userId 用户id
     * @return 是否是高风险用户
     */
    UserRiskJudgeResultBO judgeRiskUser(Long userId);
}