package com.bxm.foundation.user.facade.enums;

/**
 * 不同的用户状态
 *
 * @author liujia
 * @date 7/2/21 4:01 PM
 **/
public enum UserStatusEnum {
    /**
     * 静默用户，用户没有登录行为产生的用户
     */
    MUTE(0),

    /**
     * 正常用户
     */
    NORMAL(1),

    /**
     * 未激活的用户，在应用外进行创建的用户
     */
    NOT_ACTIVATED(2),

    /**
     * 屏蔽用户，有恶意行为的用户ID
     */
    BLACK(9),

    /**
     * 虚拟用户
     */
    VIRTUAL(8),

    /**
     * 测试用户，运营后台标注的测试用户
     */
    TEST(7),
    ;

    private int code;

    UserStatusEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public static UserStatusEnum get(int code) {
        for (UserStatusEnum statusEnum : UserStatusEnum.values()) {
            if (statusEnum.getCode() == code) {
                return statusEnum;
            }
        }

        return null;
    }

    public boolean equalsCode(int code) {
        return this.getCode() == code;
    }
}
