package com.bxm.foundation.user.facade.param;

import com.bxm.newidea.component.vo.BaseBean;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/7/28 11:26 上午
 */
@Data
@Builder
@AllArgsConstructor
public class RiskUserParam extends BaseBean {

    @Tolerate
    private RiskUserParam() {

    }

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 风控因子，0：提现绑定超过两个用户，1：创建用户到提现小于最短时长，
     * 2：绑定设备的对应的用户信息超过了2个，3：用户申请提现的来源ip超过了N个
     */
    private Integer riskFactor;

    /**
     * 触发风控的原始数据，如提现绑定的账户、创建用户到提现的时长等
     */
    private String relationInfo;

    /**
     * 备注
     */
    private String remark;
}