package com.bxm.foundation.user.facade.param;

import com.bxm.newidea.component.param.BasicParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 虚拟用户查询参数
 * 可以查询指定系统下的特定画像群体
 *
 * @author liujia
 * @date 7/1/21 10:48 AM
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class VirtualUserQueryParam extends BasicParam {

    /**
     * 虚拟用户性别，1：男、2：女，3：未知
     */
    private Integer sex;

    /**
     * 自定义的用户分组（随意字符串，保持唯一即可）
     */
    private String group;

    /**
     * 获取数量，默认为10
     */
    private Integer acquireNum = 10;

    /**
     * 如果指定分组数量不足，是否使用公共的虚拟用户进行填充
     * 默认为true，即进行填充
     */
    private Boolean fillWithPublic = true;
}
