package com.bxm.foundation.user.facade;

import com.bxm.foundation.user.facade.dto.VirtualUserDTO;
import com.bxm.foundation.user.facade.param.VirtualUserQueryParam;

import java.util.List;

/**
 * 虚拟用户对外服务接口
 *
 * @author liujia
 * @date 7/1/21 10:45 AM
 **/
public interface VirtualUserFacadeService {

    /**
     * 随机查询一批虚拟用户用于业务场景
     *
     * @param param 查询参数
     * @return 符合条件的虚拟用户，如果获取不到则返回空数组
     */
    List<VirtualUserDTO> getRandom(VirtualUserQueryParam param);

    /**
     * 随机获取一个虚拟用户
     *
     * @param param 虚拟用户的查询条件
     * @return 符合条件的虚拟用户信息，如果获取不到将返回null
     */
    VirtualUserDTO getRandomOne(VirtualUserQueryParam param);
}
