package com.bxm.foundation.user.facade.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户基础信息
 *
 * @author liujia
 * @date 7/1/21 10:41 AM
 **/
@Data
public class UserInfoDTO implements Serializable {
    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 用户所属应用
     */
    private String srcApp;

    /**
     * 用户昵称
     */
    private String nickName;

    /**
     * 用户头像
     */
    private String headImg;

    /**
     * 用户性别，1：男性、2：女性、3：未知
     */
    private Integer sex;

    /**
     * 用户账号创建时间
     */
    private Date createTime;

    /**
     * 最后一次登录时间
     */
    private Date lastLoginTime;

    /**
     * 用户状态
     * 0：静默
     * 1： 正常
     * 2：待激活
     * 7：测试用户
     * 8：虚拟用户
     * 9：已屏蔽用户
     */
    private Integer status;
}
