package com.bxm.foundation.user.facade.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 用户风控因子枚举类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/7/28 2:08 下午
 */
@Getter
@AllArgsConstructor
public enum UserRiskFactorEnum {
    /**
     * 风控因子枚举
     */
    WITHDRAW_ACCOUNT_BIND_LIMIT(0, "提现绑定超过两个用户"),

    CREATE_WITHDRAW_INTERVAL_LIMIT(1, "创建用户到提现时间间隔太短"),

    BIND_EQUIPMENT_USER_NUM_LIMIT(2, "绑定同一设备的用户超过两个"),

    WITHDRAW_IP_LIMIT(3, "用户申请提现的来源ip超过了限制个数");

    /**
     * code
     */
    private int code;

    /**
     * 描述
     */
    private String description;
}