package com.bxm.kylin._super.sdk.modal;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author allen
 * @date 2021-06-08
 * @since 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class Domain {

    private Long id;

    private String groupId;

    /**
     * www.big-mouth.cn
     */
    private String domain;

    /**
     * 1- HTTP / 2- HTTPS
     */
    private Integer protocol;

    /**
     * check uri. e.g. /index.html
     */
    private String uri;

    /**
     * true If available on this url.
     */
    private boolean available = true;

    public boolean isDisable() {
        return !available;
    }
}
