package com.bxm.kylin._super.sdk.modal;

/**
 * @author allen
 * @date 2021-06-08
 * @since 1.0
 */
public enum Protocol {

    /**
     * http
     */
    HTTP(1, "http"),
    /**
     * https
     */
    HTTPS(2, "https");

    private final int original;
    private final String name;

    Protocol(int original, String name) {
        this.original = original;
        this.name = name;
    }

    public static Protocol of(int original) {
        Protocol[] values = Protocol.values();
        for (Protocol value : values) {
            if (value.original == original) {
                return value;
            }
        }
        return Protocol.HTTP;
    }

    public int getOriginal() {
        return original;
    }

    public String getName() {
        return name;
    }
}
