/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin._super.sdk;

import com.bxm.kylin._super.sdk.CacheKey;
import com.bxm.kylin._super.sdk.Kylin;
import com.bxm.kylin._super.sdk.KylinApiClient;
import com.bxm.kylin._super.sdk.KylinProperties;
import com.bxm.kylin._super.sdk.modal.CheckPlan;
import com.bxm.kylin._super.sdk.modal.Domain;
import com.bxm.kylin._super.sdk.modal.Protocol;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.message.dingding.DingDingMessageSender;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultKylinImpl
implements Kylin {
    private static final Logger log = LoggerFactory.getLogger(DefaultKylinImpl.class);
    private final KylinApiClient client;
    private final CacheKey cacheKey;
    private final Fetcher fetcher;
    private final Updater updater;
    private final MessageSender messageSender;
    private final boolean noticeIfNecessary;

    public DefaultKylinImpl(KylinApiClient client, CacheKey cacheKey, Fetcher fetcher, Updater updater, KylinProperties kylinProperties) {
        this.client = client;
        this.cacheKey = cacheKey;
        this.fetcher = fetcher;
        this.updater = updater;
        this.messageSender = new DingDingMessageSender(kylinProperties.getDingTalkWebhookUrl());
        this.noticeIfNecessary = kylinProperties.isNoticeIfNecessary();
    }

    @Override
    public void start(String id, String groupId, String url) {
        Map<String, Domain> domains = this.getDomains(id);
        Domain available = this.getFirstAvailableDomain(domains);
        if (Objects.isNull(available)) {
            List<Domain> disableList = this.filterCollect(domains, stringDomainEntry -> !((Domain)stringDomainEntry.getValue()).isAvailable());
            String path = UriComponentsBuilder.fromUriString((String)url).build().getPath();
            available = this.getFirstAvailableDomainOnKylin(id, groupId, disableList, path);
        }
        if (Objects.isNull(available)) {
            log.warn("No available domain of ticket '{}'", (Object)id);
            this.sendMessage(String.format("ID [%s] \u6ca1\u6709\u5fae\u4fe1\u73af\u5883\u53ef\u7528\u7684\u57df\u540d", id));
            return;
        }
        String newUrl = this.buildNewUrl(available, url);
        String oldUrl = this.getUrl(id);
        if (StringUtils.equals((String)oldUrl, (String)newUrl)) {
            log.info("{} oldUrl: {}, newUrl: {}", new Object[]{id, oldUrl, newUrl});
            return;
        }
        this.updater.hupdate(this.cacheKey.hashAvailableUrl(), id, (Object)newUrl);
        this.updater.hupdate(this.cacheKey.hashDomains(id), TypeHelper.castToString((Object)available.getId()), (Object)available);
        this.refreshCheckPlanIfNecessary(id, available, newUrl);
        log.info("{} sourceUrl: {}, newUrl: {}", new Object[]{id, url, newUrl});
        if (this.noticeIfNecessary) {
            this.sendMessage(String.format("ID [%s] \n\u843d\u5730\u9875\u94fe\u63a5\n %s \n\u5f53\u524d\u5df2\u66ff\u6362\u6210\n %s", id, url, newUrl));
        }
    }

    @Override
    public void close(String id) {
        this.close(id, true);
    }

    @Override
    public void close(String id, boolean withDomains) {
        CheckPlan checkPlan = (CheckPlan)this.fetcher.hfetch(this.cacheKey.hashCheckPlan(), id, CheckPlan.class);
        if (Objects.nonNull(checkPlan)) {
            this.client.deleteCheckPlan(checkPlan.getId());
        }
        this.updater.hremove(this.cacheKey.hashAvailableUrl(), new String[]{id});
        this.updater.hremove(this.cacheKey.hashCheckPlan(), new String[]{id});
        if (withDomains) {
            this.updater.remove(this.cacheKey.hashDomains(id));
        }
        log.info("{} closed.", (Object)id);
    }

    @Override
    public void changed(final CheckPlan checkPlan) {
        if (Objects.isNull(checkPlan)) {
            return;
        }
        final boolean enable = checkPlan.isAvailable();
        Map map = this.fetcher.hfetchall(this.cacheKey.hashCheckPlan(), CheckPlan.class);
        if (MapUtils.isEmpty((Map)map)) {
            return;
        }
        map.entrySet().forEach(new Consumer<Map.Entry<String, CheckPlan>>(){

            @Override
            public void accept(Map.Entry<String, CheckPlan> entry) {
                String id = entry.getKey();
                CheckPlan plan = entry.getValue();
                if (!Objects.equals(checkPlan.getId(), plan.getId())) {
                    return;
                }
                String domainId = TypeHelper.castToString((Object)checkPlan.getDomainId());
                Domain domain = DefaultKylinImpl.this.getDomain(id, domainId);
                if (Objects.isNull(domain)) {
                    return;
                }
                domain.setAvailable(enable);
                DefaultKylinImpl.this.updater.hupdate(DefaultKylinImpl.this.cacheKey.hashDomains(id), domainId, (Object)domain);
                log.info("ID {} domain {} has changed state: {}", new Object[]{id, domainId, enable});
                String groupId = domain.getGroupId();
                String url = DefaultKylinImpl.this.getUrl(id);
                DefaultKylinImpl.this.start(id, groupId, url);
            }
        });
    }

    @Override
    public String getUrl(String id) {
        return (String)this.fetcher.hfetch(this.cacheKey.hashAvailableUrl(), id, String.class);
    }

    @Override
    public Map<String, String> getAllUrl() {
        return this.fetcher.hfetchall(this.cacheKey.hashAvailableUrl(), String.class);
    }

    @Override
    public Map<String, String> getAllCheckPlan() {
        Map map = Optional.ofNullable(this.fetcher.hfetchall(this.cacheKey.hashCheckPlan(), CheckPlan.class)).orElse(new HashMap());
        HashMap rst = Maps.newHashMap();
        map.forEach((key, value) -> rst.put(key, TypeHelper.castToString((Object)value.getId())));
        return rst;
    }

    private List<Domain> filterCollect(Map<String, Domain> domains, Predicate<Map.Entry<String, Domain>> filter) {
        return domains.entrySet().stream().filter(filter).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private Domain getFirstAvailableDomainOnKylin(String id, String groupId, List<Domain> exclude, String path) {
        List<Domain> domains = this.client.getAvailableDomains(groupId, "Mozilla/5.0 (iPhone; CPU iPhone OS 13_1_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148 MicroMessenger/7.0.8(0x17000820) NetType/4G Language/zh_CN", "61.130.182.194", path);
        if (CollectionUtils.isEmpty(domains)) {
            log.warn("No available domain of group '{}'", (Object)groupId);
            this.sendMessage(String.format("\u57df\u540d\u7ec4 [%s] \u6ca1\u6709\u5fae\u4fe1\u73af\u5883\u53ef\u7528\u7684\u57df\u540d", groupId));
            return null;
        }
        if (!CollectionUtils.isEmpty(exclude)) {
            Set excludeIds = exclude.stream().map(Domain::getId).collect(Collectors.toSet());
            domains.removeIf(domain -> excludeIds.contains(domain.getId()));
        }
        if (CollectionUtils.isEmpty(domains)) {
            log.warn("After remove, No available domain of group '{}'", (Object)groupId);
            this.sendMessage(String.format("ID [%s] \u57df\u540d\u7ec4 [%s] \u6ca1\u6709\u5fae\u4fe1\u73af\u5883\u53ef\u7528\u7684\u57df\u540d", id, groupId));
            return null;
        }
        int remain = domains.size() - 1;
        if (remain <= 2) {
            log.warn("id [{}] group [{}] available domain quantity less: {}", new Object[]{id, groupId, remain});
            this.sendMessage(String.format("ID [%s] \u57df\u540d\u7ec4 [%s] \u5fae\u4fe1\u73af\u5883\u5269\u4f59\u53ef\u7528\u57df\u540d\u6570\u4e3a %s", id, groupId, remain));
        }
        return domains.iterator().next();
    }

    private Domain getFirstAvailableDomain(Map<String, Domain> domains) {
        if (MapUtils.isNotEmpty(domains)) {
            for (Map.Entry<String, Domain> entry : domains.entrySet()) {
                Domain domain = entry.getValue();
                if (!domain.isAvailable()) continue;
                return domain;
            }
        }
        return null;
    }

    private Map<String, Domain> getDomains(String id) {
        KeyGenerator hashDomains = this.cacheKey.hashDomains(id);
        return Optional.ofNullable(this.fetcher.hfetchall(hashDomains, Domain.class)).orElse(new HashMap());
    }

    private Domain getDomain(String id, String domainId) {
        return (Domain)this.fetcher.hfetch(this.cacheKey.hashDomains(id), domainId, Domain.class);
    }

    private String buildNewUrl(Domain domain, String sourceUrl) {
        return UriComponentsBuilder.fromUriString((String)sourceUrl).scheme(Protocol.of(domain.getProtocol()).getName()).host(domain.getDomain()).build().toString();
    }

    private void refreshCheckPlanIfNecessary(String id, Domain domain, String url) {
        CheckPlan latest;
        CheckPlan current = (CheckPlan)this.fetcher.hfetch(this.cacheKey.hashCheckPlan(), id, CheckPlan.class);
        if (Objects.nonNull(current)) {
            String path = UriComponentsBuilder.fromUriString((String)url).build().getPath();
            boolean alikeDomain = Objects.equals(current.getDomainId(), domain.getId());
            boolean alikePath = StringUtils.equals((String)current.getCheckPath(), (String)path);
            if (current.isAvailable() && alikeDomain && alikePath) {
                return;
            }
        }
        if (Objects.isNull(latest = this.client.createCheckPlan(2L, null, domain.getId(), url))) {
            this.sendMessage(String.format("ID [%s] \u521b\u5efa\u76d1\u6d4b\u8ba1\u5212\u5931\u8d25\u4e86\uff01", id));
            return;
        }
        this.updater.hupdate(this.cacheKey.hashCheckPlan(), id, (Object)latest);
        if (Objects.nonNull(current)) {
            this.client.deleteCheckPlan(current.getId());
        }
    }

    private void sendMessage(String content) {
        try {
            this.messageSender.send2(new Message(content));
        }
        catch (Exception e) {
            log.warn("send2: ", (Throwable)e);
        }
    }
}

