package com.bxm.log.facade.dao;


import java.io.Serializable;
import java.util.Date;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/04/23 10:49
 */
public class LogModel implements Serializable{


	//券状态
	public static final int STATUS = 1;
	//券预算
	public static final int BUDGET = 2;
	//券调价
	public static final int PRICE  = 3;

	/**
	 * ①区分操作人员，需要对应操作账号，广告主后台只显示广告主的操作日志（广告后台有代理商、子账号、直客三种账号）；

	 ②操作类型可筛选，券状态、券预算、券调价等；

	 ③广告主后台操作日志全部针对到广告券，可根据广告券进行对应操作日志搜索
	 */
	private static final long serialVersionUID = 2645156368705722971L;
	private String id;
	private String ip;
	private String userName;
	private String userAccount;
	private Date dateTime = new Date();
	private String content;
	private String operationType;
	private String adticketId;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getUserAccount() {
		return userAccount;
	}

	public void setUserAccount(String userAccount) {
		this.userAccount = userAccount;
	}

	public Date getDateTime() {
		return dateTime;
	}

	public void setDateTime(Date dateTime) {
		if(dateTime == null){
			this.dateTime = dateTime;
		}
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getOperationType() {
		return operationType;
	}

	public void setOperationType(String operationType) {
		this.operationType = operationType;
	}

	public String getAdticketId() {
		return adticketId;
	}

	public void setAdticketId(String adticketId) {
		this.adticketId = adticketId;
	}

}
