package com.bxm.log.facade.dao;


import com.bxm.log.facade.dto.CollectionName;

import java.io.Serializable;
import java.util.Date;

/**
 * <h3>Shenjue.java基本描述</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2018/04/23 10:49
 */
public class LogModel implements Serializable{


	//券状态
	public static final int STATUS = 1;
	//券预算
	public static final int BUDGET = 2;
	//券调价
	public static final int PRICE  = 3;

	/**
	 * ①区分操作人员，需要对应操作账号，广告主后台只显示广告主的操作日志（广告后台有代理商、子账号、直客三种账号）；

	 ②操作类型可筛选，券状态、券预算、券调价等；

	 ③广告主后台操作日志全部针对到广告券，可根据广告券进行对应操作日志搜索
	 */
	private static final long serialVersionUID = 2645156368705722971L;
	private String id;
	private String ip;
	private String userName;
	private String userAccount;
	private String parentAccount;
	private Date dateTime = new Date();
	private String content;
	private String operationType;
	private String adticketId;
	private String  collectionName ;
	//日志内容,同content一样,非json格式
	private String logInfo;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getUserAccount() {
		return userAccount;
	}

	public void setUserAccount(String userAccount) {
		this.userAccount = userAccount;
	}

	public Date getDateTime() {
		return dateTime;
	}

	public void setDateTime(Date dateTime) {
		if(dateTime != null){
			this.dateTime = dateTime;
		}
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getOperationType() {
		return operationType;
	}

	public void setOperationType(String operationType) {
		this.operationType = operationType;
	}

	public String getAdticketId() {
		return adticketId;
	}

	public void setAdticketId(String adticketId) {
		this.adticketId = adticketId;
	}

	public String getCollectionName() {
		if(collectionName == null){
			this.collectionName = CollectionName.ADSMANAGER;
		}
		return collectionName;
	}

	public void setCollectionName(String collectionName) {
		this.collectionName = collectionName;
	}

	public String getParentAccount() {
		return parentAccount;
	}

	public void setParentAccount(String parentAccount) {
		this.parentAccount = parentAccount;
	}
	
	public String getLogInfo() {
        return logInfo;
    }

    public void setLogInfo(String logInfo) {
        this.logInfo = logInfo;
    }



    public static class Builder {
		private  String id;
		private String ip;
		private String userName;
		private String userAccount;
		private Date dateTime = new Date();
		private String content;
		private String operationType;
		private String adticketId;
		private String  collectionName;
		private String parentAccount;
	    private String logInfo;

		public Builder id(String id){
			this.id= id;
			return this;
		}
		public Builder ip(String ip){
			this.ip= ip;
			return this;
		}
		public Builder userName(String userName){
			this.userName= userName;
			return this;
		}
		public Builder userAccount(String userAccount){
			this.userAccount= userAccount;
			return this;
		}
		public Builder dateTime(Date dateTime){
			this.dateTime= dateTime;
			return this;
		}
		public Builder content(String content){
			this.content= content;
			return this;
		}
		public Builder operationType(String operationType){
			this.operationType= operationType;
			return this;
		}
		public Builder adticketId(String adticketId){
			this.adticketId= adticketId;
			return this;
		}
		public Builder collectionName(String collectionName){
			this.collectionName= collectionName;
			return this;
		}
		public Builder parentAccount(String parentAccount){
			this.parentAccount= parentAccount;
			return this;
		}
		
		public Builder logInfo(String logInfo){
            this.logInfo= logInfo;
            return this;
        }
		
		
		public LogModel build(){
			return new LogModel(this);
		}
	}

	public LogModel (Builder builder){
		this.adticketId=builder.adticketId;
		this.collectionName=builder.collectionName;
		this.content=builder.content;
		this.dateTime=builder.dateTime;
		this.id=builder.id;
		this.ip=builder.ip;
		this.userName=builder.userName;
		this.operationType=builder.operationType;
		this.userAccount=builder.userAccount;
		this.parentAccount=builder.parentAccount;
		this.logInfo = builder.logInfo;
	}
	public LogModel(){}
}
