package com.bxm.log.facade.service;

import com.bxm.log.facade.dao.LogModel;
import com.bxm.log.facade.dao.Page;
import com.bxm.log.facade.dto.LogModelDto;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * <h3></h3>
 * @author hcmony
 * @since V1.0.0, 2018/04/21 16:57
 */
@FeignClient("logs-web")
@RequestMapping("/logs")
public interface LogsService {

    @RequestMapping("/test")
    public void test();

    /**
     * 新增
     * @param logModel
     * @return
     */
    @RequestMapping(value = "/add",method = RequestMethod.POST)
    public ResultModel<Boolean> add(@RequestBody LogModel logModel);

    @RequestMapping(value = "/findBykeyworkds",method = RequestMethod.POST)
    public Page<LogModel> find(@RequestBody LogModelDto model);
    
    @RequestMapping(value = "/exportLogs",method = RequestMethod.POST)
    public List<LogModel> exportLogs(@RequestBody LogModelDto model);
}
