/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.log.controller.mongo;

import com.bxm.log.dal.utils.ResultModelFactory;
import com.bxm.log.facade.dao.LogModel;
import com.bxm.log.facade.dao.Page;
import com.bxm.log.facade.dto.LogModelDto;
import com.bxm.log.service.mongo.LogService;
import com.bxm.util.dto.ResultModel;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logs"})
public class LogsController {
    private static final Logger logger = Logger.getLogger(LogsController.class);
    @Autowired
    private LogService logService;

    @RequestMapping(value={"/test"})
    public void test() {
        System.out.println("---------------");
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel<Boolean> add(@RequestBody LogModel logModel) {
        Boolean result = false;
        try {
            result = this.logService.add(logModel);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ResultModelFactory.SUCCESS((Serializable)result);
    }

    @RequestMapping(value={"/findBykeyworkds"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public Page<LogModel> find(@RequestBody LogModelDto model) {
        Page page = new Page();
        try {
            page = this.logService.findBykeyworkds(model);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return page;
    }

    @RequestMapping(value={"/exportLogs"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public List<LogModel> exportLogs(@RequestBody LogModelDto model) {
        List list = null;
        try {
            list = this.logService.exportLogs(model);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return list;
    }
}

