package com.bxm.mccms.facade.model.pushable;

import java.math.BigDecimal;

import lombok.Data;

/**
 * 推送模型-广告位<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/27 13:47
 */
@Data
public class PositionCacheVO implements java.io.Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 广告位
     */
    private String positionId;

    /**
     * 媒体端广告位ID
     */
    private String appPositionId;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 媒体底价
     */
    private BigDecimal basePrice;

    /**
     * 是否已关闭：1 表示已关闭，0 表示未关闭
     */
    private Integer closedFlag;

    /**
     * 广告位场景：由于有太多，还可能会增加，这里不再列举，请从ssp后台查看对应枚举
     */
    private Integer positionScene;

    /**
     * 屏蔽规则ID,多个用逗号分隔
     */
    private String shieldStrategyIds;
}
