package com.bxm.mccms.facade.service;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.mccms.facade.constant.Constants;
import com.bxm.mccms.facade.model.reviewrefuseconfig.ReviewRefuseConfigFacadeDTO;
import com.bxm.mccms.facade.model.reviewrefuseconfig.ReviewRefuseConfigFacadeVO;

/**
 * <p>
 * 审核维护配置 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-22
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface IReviewRefuseConfigFacadeService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @RequestMapping(value = "/facade/reviewRefuseConfig/list", method = RequestMethod.POST, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<ReviewRefuseConfigFacadeVO>> list(@RequestBody ReviewRefuseConfigFacadeDTO dto);

    /**
     * 根据ID查询列表
     * @param ids
     * @return
     */
    @RequestMapping(value = "/facade/reviewRefuseConfig/listByIds", method = RequestMethod.GET, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<ReviewRefuseConfigFacadeVO>> listByIds(@RequestParam(value = "ids") List<Long> ids);


}
