package com.bxm.mccms.facade.model.pushable;

import java.io.Serializable;
import java.math.BigDecimal;

import lombok.Data;

/**
 * 推送模型-广告平台<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/27 15:19
 */
@Data
public class DspCacheVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * DSP ID
     */
    private Long id;
    /**
     * DSP 代码
     */
    private String dspCode;
    /**
     * DSP名称
     */
    private String dspName;
    /**
     * 接口地址
     */
    private String apiUrl;
    /**
     * 接口密钥
     */
    private String apiKey;
    /**
     * 扩展属性,当通用配置无法满足对接时，请将需要的属性按照JSON格式填在这个字段中。
     */
    private String ext;

    /**
     * 连接超时设置,单位为毫秒
     */
    private Integer connectTimeOut;

    /**
     * 读取结果超时设置,单位为毫秒
     */
    private Integer socketTimeOut;

    /**
     * QPS限制
     */
    private Integer qps;

    /**
     * 广告主
     */
    private Long advertiser;

    /**
     * 结算方式
     * @see com.bxm.mccms.facade.enums.DspEnum.SettleType
     */
    private Integer settleType;

    /**
     * 结算配置:结算方式为分成时为0-100分成比例，结算方式为固价时为0-200固价CPM
     */
    private BigDecimal settleConfig;

    /**
     * 是否删除,1:已删除
     */
    private Integer deleted;
}
