package com.bxm.mccms.facade.enums;

/**
 * <p>
 * 任务规则类型 枚举
 * 1- 地域限制、2- 广告位黑白名单、3- 频次限制、
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-3-25
 */
public enum RuleTypeEnum {

    REGION(1, "地域限制"),
    POSITION(2, "广告位黑白名单"),
    FREQUENCYS(3, "频次限制"),
    APP(4, "开发者应用限制"),
    DEVICE_BRAND(5, "设备品牌限制"),
    TIME_SLOT(6, "投放时段"),
    ;

    private int value;
    private String name;

    RuleTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public static RuleTypeEnum get(int value) {
        for (RuleTypeEnum temp : RuleTypeEnum.values()) {
            if (temp.value == value) {
                return temp;
            }
        }
        return null;
    }

}
