package com.bxm.mccms.facade.model.pushable;

import java.io.Serializable;

import lombok.Data;

/**
 * <p>
 * 推送模型-游戏模板
 * 这个是活动后台配置的游戏模板数据
 * </p>
 *
 * @author zhengwangeng
 * @since 2022-3-2
 */
@Data
public class GameTemplateCacheVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 类型
     * 1、提现类
     * 2、实物类
     * 3、积分打通
     */
    public static final short TYPE_MONEY = 1;
    public static final short TYPE_OBJECT = 2;
    public static final short TYPE_INTEGRAL = 3;

    /**
     * 周期
     * 1、7天=周
     * 2、30天=月
     * 3、永久
     */
    public static final short CYCLE_WEEK = 1;
    public static final short CYCLE_MONTH = 2;
    public static final short CYCLE_FOREVER = 3;

    /**
     * 1、未开启状态：皆可修改
     * 2、开启状态：可修改游戏名称/游戏类型/游戏周期，游戏状态可修改为停用状态，不可修改基础配置和发奖参数
     * 3、停用状态：可修改游戏名称/游戏类型/游戏周期，游戏状态可修改为启用状态，不可修改基础配置和发奖参数
     */
    public static final short STATUS_UN_OPENED = 1;
    public static final short STATUS_OPEN = 2;
    public static final short STATUS_STOP = 3;

    /**
     * ID
     */
    private Long id;

    /**
     * 代号
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 类型
     */
    private Short type;

    /**
     * 周期
     */
    private Short cycle;

    /**
     * 状态
     */
    private Short status;

    /**
     * 具体配置Json
     */
    private String jsonConfig;

    /**
     * 创建人
     */
    private String createUser;

}
