package com.bxm.mccms.facade.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bxm.mccms.facade.constant.Constants;
import com.bxm.mccms.facade.model.activity.ActivityFacadeDTO;

/**
 * <p>
 * 活动 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-8-27
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface ISceneActivityFacadeService {

    /**
     * 同步活动链接
     * @param dto
     * @return
     */
    @RequestMapping(value = "/facade/sceneActivity/sync/url", method = RequestMethod.POST, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> syncSceneActivityUrl(@RequestBody ActivityFacadeDTO dto);


}
