package com.bxm.mccms.facade.enums;

/**
 * DSP相关 枚举
 *
 * @author zhengwangeng
 * @since 2022-5-24
 */
public interface DspEnum {

    /**
     * 结算方式：1分成，2固价，3实时竞价
     */
    enum SettleType {

        /** 分成 */
        DIVIDE_INTO(1,"分成"),
        /** 定价 */
        RTB(2,"固价"),
        /** 实时竞价 */
        REAL_TIME_RTB(3,"实时竞价"),
        ;

        private Integer type;
        private String name;

        SettleType(Integer type, String name) {
            this.type = type;
            this.name = name;
        }

        public Integer getType() {
            return type;
        }

        public String getName() {
            return name;
        }

        public static SettleType get(Integer type) {
            if (null == type) {
                return null;
            }
            for (SettleType anEnum : values()) {
                if (anEnum.getType().equals(type)) {
                    return anEnum;
                }
            }
            return null;
        }
    }
}
