package com.bxm.mccms.facade.enums;

/**
 * 广告位创意审核<br/>
 *
 * @author kerry.jiang
 * @date 2019/12/30 10:17
 */
public class PositionDspCreativeEnum {

    /**
     * 审核状态
     */
    public static enum AuditStatus {

        /** 待审核 */
        WAIT(0,"待审核"),
        /** 通过 */
        PASS(1,"通过"),
        /** 不通过 */
        REFUSE(2,"不通过"),
        ;
        
        /**
         * 值
         */
        private int id;
        /**
         * 描述
         */
        private String desc;

        AuditStatus(int id, String desc) {
            this.id = id;
            this.desc = desc;
        }

        public int getId() {
            return id;
        }

        public String getDesc() {
            return desc;
        }
    }
}
