package com.bxm.mccms.facade.service;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bxm.mccms.facade.constant.Constants;
import com.bxm.mccms.facade.model.income.PanguChannelIncomeFacadeDTO;

/**
 * <p>
 * 同步渠道收益到盘古代理收益 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2022-01-04
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface IPanguChannelIncomeSyncFacadeService {

    /**
     * 同步渠道收益到盘古代理收益
     * @param dto
     * @return
     */
    @RequestMapping(value = "/facade/sync/pangu/channelIncome", method = RequestMethod.POST, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> syncPanguChannelIncome(@RequestBody List<PanguChannelIncomeFacadeDTO> dto);


}
