package com.bxm.mccms.facade.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * 转换目标 12-首次唤起
 */
@Getter
public enum ConversionTargetEnum {

    FIRST(12, "首次唤起");

    private Integer code;
    private String desc;

    ConversionTargetEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code) {
        if (Objects.isNull(code)){
            return null;
        }
        for (ConversionTargetEnum type : ConversionTargetEnum.values()) {
            if (type.getCode().equals(code)) {
                return type.getDesc();
            }
        }
        return null;
    }
}
