package com.bxm.mccms.facade.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author jingyu.li
 * @date 2024-01-17
 */
public interface DspPosPriceEnum {

    @AllArgsConstructor
    @Getter
    enum MediaOfferType {
        FIXED(1, "固价"),
        NOT_SET(2, "动态出价（不设置）"),
        ;

        private Integer code;

        private String desc;
    }

    @AllArgsConstructor
    @Getter
    enum AdvertiserOfferType {
        NOT_SET(1, "不设置"),
        FIXED(2, "固价"),
        DISCOUNT(3, "打折）"),
        ;

        private Integer code;

        private String desc;
    }
}
