package com.bxm.mccms.facade.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 系统规则配置类型枚举
 * </p>
 *
 * @author jingyu.li
 * @since 2022-9-19
 */
public enum TblAdRulesTypeEnum {

    /**
     * 已安装App定向黑白名单
     */
    INSTALLED_WHITE_BLACK_LIST("已安装App定向黑白名单", 1),
    MEDIA_WHITE_BLACK_LIST("媒体App定向黑白名单", 2),
    CROWD_PACKAGE("人群包定向", 3),
    REGIONAL_ORIENTATION("地域定向", 4),
    FREQUENCY("频次控制", 5),
    DEVICE_INFO("设备信息定向", 6),
    POSITION_FREQUENCY_CONTROL("广告位频控",7),
    MEDIA_ID_WHITE_BLACK_LIST("媒体appId定向",8),
    MEDIA_TAG_ID_WHITE_BLACK_LIST("媒体tagId定向",9)
    ;

    /**
     * 名称
     */
    private final String name;

    /**
     * 类型
     */
    private final Integer type;


    TblAdRulesTypeEnum(String name, Integer type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public Integer getType() {
        return type;
    }

    public static List<Integer> getDspPosRuleTypes() {
        return Arrays.asList(1,2,3,4,5,6,8);
    }
}
