package com.bxm.mccms.facade.model.pushable;

import com.bxm.mccms.facade.model.Rule;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * dsp出价配置明细
 * @author jingyu.li
 * @date 2023-01-06
 */
@Data
public class DispatcherDspPosPriceConfigVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * dsp配置id
     */
    private Long positionDspPosId;

    /**
     * 广告位id
     */
    private String positionId;

    /**
     * 开始时段
     */
    private Integer startTime;

    /**
     * 结束时段
     */
    private Integer endTime;

    /**
     * 出价系数
     */
    private BigDecimal biddingCoefficient;

    /**
     * 利润率
     */
    private BigDecimal profitMargin;

    /**
     * cpc出价上限
     */
    private BigDecimal cpcUpperLimit;

    /**
     * 广告主出价折扣分割线
     */
    private BigDecimal priceSplit;

    /**
     * 0-price_split时的折扣
     */
    private BigDecimal ltPriceDiscountFactor;

    /**
     * price_split以上时的折扣
     */
    private BigDecimal gtPriceDiscountFactor;

    /**
     * cpm出价
     */
    private BigDecimal dspCpmPrice;


    /**
     * 媒体出价类型0固价，1动态出价（不设置）,2固价+打折，3按广告主出价
     */
    private Integer mediaOfferType;

    /**
     * 媒体出价类型为固价时的出价金额
     */
    private BigDecimal mediaOfferPrice;

    /**
     * 广告主出价类型1不设置（按dsp出价成交），2固价，3打折，4：按媒体成交价
     */
    private Integer advertiserOfferType;


    /**
     * 广告主赢价计算方式 0：打折后dsp出价，1：按媒体成交价
     */
    private Integer advertiserWinPriceType;

    /**
     * 广告主出价类型为固价时的出价金额
     */
    private BigDecimal advertiserOfferPrice;

    /**
     * 广告主按媒体成交价计算时的利润率
     */
    private BigDecimal advertiserProfitMargin;


    private Long priceModeId;

    private String priceModeName;

    /**
     * 过滤模式0：不限，1：白名单，2：黑名单
     */
    private Integer filterMode;

    private String taskId;

    /**
     * app包名过滤模式0:不限，1:白名单，2:黑名单
     */
    private Integer appPkgFilterMode;

    /**
     * 需定向的app包名
     */
    private String appPackages;

    /**
     * 投放域名过滤模式0:不限，1:白名单，2:黑名单
     */
    private Integer domainFilterMode;

    /**
     * 投放域名定向
     */
    private String domains;

    /**
     * 曝光控制模式0:不限，1:设置曝光上限
     */
    private Integer exposureFilterMode;

    /**
     * 需控制的曝光数值
     */
    private Integer exposureValue;

    /**
     * 投放媒体广告位过滤模式0:不限，1:白名单，2:黑名单
     */
    private Integer mediaTagIdFilterMode;

    /**
     * 媒体广告位定向
     */
    private String mediaTagIdDirect;

    /**
     * 需过滤的dsp出价最低数值
     */
    private BigDecimal filterDspPrice;

    /**
     * 开关0：开，1：关
     */
    private Integer opened;

    /**
     * 媒体价格单位cpm-1/cpc-2/ocpm-3
     */
    private Integer mediaCostType;

    /**
     * 转化目标 12-首次唤起
     */
    private Integer conversionTarget;

    /**
     * 人群包定向,多个逗号分隔 示例："1,2&3" 1,2是白，3是黑
     */
    private Rule crowdPackageOrientation;
    /**
     * 智能策略 0无/1利润率优选
     */
    private Integer strategy;

    /**
     * 利润率下限
     */
    private BigDecimal profitMarginLower;

    /**
     * 利润率上限
     */
    private BigDecimal profitMarginUpper;
}
